package cronapp.framework.authentication.token;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Component
public class EntryPointUnauthorizedHandler implements AuthenticationEntryPoint {

  @Override
  public void commence(HttpServletRequest request, HttpServletResponse response,
      AuthenticationException authException)
      throws IOException {
    Map<String, Object> data = new HashMap<>();
    data.put("timestamp", Calendar.getInstance().getTime());
    data.put("exception", authException.getMessage());
    ObjectMapper objectMapper = new ObjectMapper();
    response.sendError(HttpServletResponse.SC_UNAUTHORIZED, objectMapper.writeValueAsString(data));
  }
}