package cronapp.framework.authentication.security;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import cronapi.Var;
import cronapp.framework.api.ApiManager;
import cronapp.framework.api.EventsManager;
import cronapp.framework.api.User;
import cronapp.framework.authentication.token.TokenUtils;
import cronapp.framework.i18n.Messages;
import org.apache.commons.lang3.StringUtils;
import org.springframework.mobile.device.DeviceResolver;
import org.springframework.mobile.device.LiteDeviceResolver;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.stream.Collectors;

public class CronappAuthenticationSuccessHandler extends SimpleUrlAuthenticationSuccessHandler {
  @Override
  public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
    clearAuthenticationAttributes(request);
    String userName = authentication.getName();
    ApiManager apiManager = ApiManager.byUserAndPassword(userName, null, "saml", true, null);

    try {
      User user = apiManager.getUser((CronappUserDetails) authentication.getDetails());

      boolean root = authentication.getAuthorities().stream()
          .map(GrantedAuthority::getAuthority)
          .anyMatch(authority -> StringUtils.equals(authority, "Administratros"));

      String roles = authentication.getAuthorities().stream()
          .map(GrantedAuthority::getAuthority)
          .collect(Collectors.joining(","));


      Gson gson = new Gson();
      JsonObject json = new JsonObject();
      json.add("user", gson.toJsonTree(user.resetPassword()));
      json.add("picture", gson.toJsonTree(user.getPicture()));
      json.addProperty("roles", roles);
      json.addProperty("theme", "");
      json.addProperty("root", root);

      if (EventsManager.hasEvent("onLogin")) {
        EventsManager.executeEventOnTransaction("onLogin", Var.valueOf("username", authentication.getName()));
      }

      DeviceResolver deviceResolver = new LiteDeviceResolver();
      String token = TokenUtils.generateToken((UserDetails) authentication.getDetails(), user.getName(), deviceResolver.resolveDevice(request), "saml");

      response.setStatus(HttpServletResponse.SC_OK);
      getRedirectStrategy().sendRedirect(request, response, "/#/connected?_ctk=" + token);

    } catch (Exception e) {
      throw new AuthenticationServiceException(Messages.getString("AuthError", e.getMessage()), e);
    }
  }
}
