package cronapp.framework;

import cronapi.Var;
import cronapp.framework.api.EventsManager;
import org.eclipse.persistence.config.PersistenceUnitProperties;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.jpa.metadata.MetadataSourceAdapter;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.sessions.Session;

import java.util.Map;

public class CronappMetadataSource extends MetadataSourceAdapter implements SessionCustomizer {
  @Override
  public Map<String, Object> getPropertyOverrides(Map<String, Object> properties, ClassLoader classLoader, SessionLog log) {
    if (!EventsManager.hasEvent("onConfigureConnection")) {
      return properties;
    }

    Var configuration = EventsManager.executeEventOnTransaction(
        "onConfigureConnection",
        Var.valueOf("connection", properties.get("cronapp.diagram.namespace"))
    );

    if (configuration.isString()) {
      properties.put(PersistenceUnitProperties.NON_JTA_DATASOURCE, configuration.toString());
    } else {
      properties.put(PersistenceUnitProperties.JDBC_DRIVER, configuration.get("driver"));
      properties.put(PersistenceUnitProperties.JDBC_URL, configuration.get("url"));
      properties.put(PersistenceUnitProperties.JDBC_USER, configuration.get("user"));
      properties.put(PersistenceUnitProperties.JDBC_PASSWORD, configuration.get("password"));
      properties.put(PersistenceUnitProperties.NON_JTA_DATASOURCE, "");
    }

    return properties;
  }

  @Override
  public void customize(Session session) throws Exception {
    session.setProperty("1", "");
  }
}
