import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.assertj.core.util.Files;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public class CronappApplication {

  public static void run(String[] args) throws Exception {
    Path webappPath = Paths.get("src/main/webapp/");
    Path mobilePath = Paths.get("src/main/mobileapp/www/");
    Tomcat tomcat = new Tomcat();

    //The port that we should run on can be set into an environment variable.
    //Look for that variable and default to 8080 if it isn't there.
    String port = System.getenv("PORT");
    if (port == null || port.isEmpty()) {
      port = "8000";
    }

    File baseDir = Files.newTemporaryFolder();
    baseDir.mkdirs();

    tomcat.setPort(Integer.valueOf(port));
    tomcat.setBaseDir(baseDir.getAbsolutePath());
    tomcat.enableNaming();
    tomcat.getConnector();

    if (mobilePath.toFile().exists()) {
      StandardContext mobileContext = (StandardContext) tomcat.addWebapp("", mobilePath.toAbsolutePath().toString());
      mobileContext.setDefaultContextXml(Paths.get("config/context.xml").toAbsolutePath().toString());
      if (webappPath.toFile().exists()) {
        StandardContext webContext = (StandardContext) tomcat.addWebapp("webapp", webappPath.toAbsolutePath().toString());
        webContext.setDefaultContextXml(Paths.get("config/context.xml").toAbsolutePath().toString());
      }
    } else {
      if (webappPath.toFile().exists()) {
        StandardContext webContext = (StandardContext) tomcat.addWebapp("", webappPath.toAbsolutePath().toString());
        webContext.setDefaultContextXml(Paths.get("config/context.xml").toAbsolutePath().toString());
      } else {
        File docBase = Files.newTemporaryFolder();
        docBase.mkdirs();
        tomcat.addWebapp("", docBase.getAbsolutePath());
      }
    }

    tomcat.start();
    tomcat.getServer().await();
  }
}
