package cronapp.framework.authentication.sso;

import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;

import java.util.Map;

public class CustomPrincipalExtractor implements PrincipalExtractor {

  private static final String[] PRINCIPAL_KEYS = new String[]{"username", "login", "email", "preferred_username", "user",
      "userid", "user_id", "id", "name", "sub"};

  @Override
  public Object extractPrincipal(Map<String, Object> map) {

    String customPrincipalKey = System.getProperty("security.oauth2.client.customPrincipalKey");

    if (!StringUtils.isBlank(customPrincipalKey)) {
      Object extractedPrincipal = map.get(customPrincipalKey);
      if (extractedPrincipal != null) {
        return String.valueOf(extractedPrincipal);
      }
    }
    for (String key : PRINCIPAL_KEYS) {
      if (map.containsKey(key)) {
        return String.valueOf(map.get(key));
      }
    }
    return "unknown";
  }
}