package cronapp.framework.authentication.sso;

import cronapp.framework.authentication.token.AuthenticationController;
import cronapp.framework.authentication.token.AuthenticationResponse;
import cronapp.framework.tenant.TenantComponent;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.mobile.device.DeviceResolver;
import org.springframework.mobile.device.LiteDeviceResolver;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@RestController
@RequestMapping("auth")
public class SSORESTController {

  private AuthenticationController authenticationController;

  public SSORESTController(@Nullable TenantComponent tenantComponent) {
    authenticationController = new AuthenticationController(tenantComponent);
  }

  @RequestMapping(method = RequestMethod.POST)
  public ResponseEntity<AuthenticationResponse> authenticationRequest(@RequestParam String username, String password, @RequestHeader(name = "X-AUTH-TOKEN", required = false) String token, final HttpServletRequest request) throws AuthenticationException {
    DeviceResolver deviceResolver = new LiteDeviceResolver();
    return authenticationController.auth(username, password, deviceResolver.resolveDevice(request), "local", token, null, request);
  }

  @RequestMapping(value = "refresh", method = RequestMethod.GET)
  public ResponseEntity<?> authenticationRequest(HttpServletRequest request) {
    return authenticationController.authenticationRequest(request);
  }

  @RequestMapping(value = "/signin/sso", method = RequestMethod.GET)
  @ResponseBody
  public String forwardLoginSSO(@RequestParam(name = "_ctk") String _ctk, HttpServletRequest request) {

    String forwardPage = "<!DOCTYPE html>" +
        "<html>" +
        "<head>" +
        "    <meta charset='UTF-8'>" +
        "    <meta http-equiv='Content-Security-Policy' content=\"default-src * cronapp://*; connect-src * cronapp:;script-src 'unsafe-inline';\">" +
        "</head>" +
        "<body>" +
        "    <script>" +
        "       try { " +
        "         let data = {'type': 'sso_user', '_ctk': '" + _ctk + "' }; " +
        "         let parentWindow = window.opener; " +
        "         parentWindow.postMessage(data, location.href); " +
        "       } catch(error) { " +
        "         console.error(error); " +
        "       } " +
        "       window.location.assign('"+request.getContextPath() + "/#/connected?_ctk=" + _ctk +"');  " +
        "    </script>" +
        "" +
        "</body>" +
        "</html>";
    return forwardPage;
  }
}



