package cronapp.framework.authentication.external;

import cronapi.AppConfig;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryLdapAuthenticationProvider;

import java.util.LinkedHashMap;
import java.util.Map;

class ActiveDirectoryAuthenticator extends BasedInLdapAuthenticator {

  @Override
  public Authentication authenticate(Authentication authentication) throws AuthenticationException {
    ActiveDirectoryLdapAuthenticationProvider provider = new ActiveDirectoryLdapAuthenticationProvider(AppConfig.defaultDomain(), generateProviderUrl());
    provider.setSearchFilter("(&(objectClass=user)(sAMAccountName={1}))");
    provider.setUserDetailsContextMapper(new ActiveDirectoryUserDetailsMapper(AppConfig.defaultDomain()));
    if (generateProviderUrl().startsWith("ldaps")) {
      Map<String, Object> environment = new LinkedHashMap<>();
      System.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", "true");
      environment.put("java.naming.ldap.factory.socket", "cronapp.framework.authentication.external.AcceptAllSSLSocketFactory");
    //  provider.setContextEnvironmentProperties(environment);
    }
    return provider.authenticate(authentication);
  }
}
