package cronapp.framework.boot;

import org.eclipse.persistence.config.PersistenceUnitProperties;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.annotation.Bean;

public abstract class CronappInitializer extends SpringBootServletInitializer {
  static {
    String[] candidates = new String[]{"/META-INF/persistence.xml", "/WEB-INF/classes/META-INF/persistence.xml"};
    for (String candidate : candidates) {
      if (CronappInitializer.class.getResource("/" + candidate) != null) {
        System.setProperty(PersistenceUnitProperties.ECLIPSELINK_PERSISTENCE_XML, candidate);
        break;
      }
    }
  }

  @Bean
  public ServletWebServerFactory servletContainer() {
    return new CronappWebServerFactory();
  }
}
