package cronapp.framework.authentication.external;

import cronapi.AppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import java.util.Hashtable;

abstract class BasedInLdapAuthenticator implements ExternalAuthenticator {

  private static final Logger log = LoggerFactory.getLogger(BasedInLdapAuthenticator.class);

  private static final String LDAP_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";

  boolean authenticate(String providerUrl, String principal, String credentials) {
    Hashtable<String, String> environment = new Hashtable<>(5);
    if (providerUrl.startsWith("ldaps")) {
      System.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", "true");
    }
    environment.put(Context.INITIAL_CONTEXT_FACTORY, LDAP_CONTEXT_FACTORY);
    environment.put(Context.PROVIDER_URL, providerUrl);
    environment.put(Context.SECURITY_AUTHENTICATION, "simple");
    environment.put(Context.SECURITY_PRINCIPAL, principal);
    environment.put(Context.SECURITY_CREDENTIALS, credentials);
    if (providerUrl.startsWith("ldaps")) {
      environment.put("java.naming.ldap.factory.socket", "cronapp.framework.authentication.external.AcceptAllSSLSocketFactory");
    }
    DirContext context = null;

    try {
      context = new InitialDirContext(environment);
    } catch (NamingException e) {
      log.error(e.getMessage(), e);
      return false;
    } finally {
      if (context != null) {
        try {
          context.close();
        } catch (NamingException ignored) {
        }
      }
    }
    return true;
  }

  String generateProviderUrl() {
    String hostname = AppConfig.hostname();
    String providerUrl;

    if (hostname.startsWith("ldap://") || hostname.startsWith("ldaps://")) {
      providerUrl = hostname;
    } else {
      providerUrl = "ldap://" + hostname;
    }

    return providerUrl;
  }
}