package cronapp.framework.boot;

import org.apache.catalina.Context;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.xml.sax.SAXException;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CronappWebServerFactory extends TomcatServletWebServerFactory {

  @Override
  protected TomcatWebServer getTomcatWebServer(Tomcat tomcat) {
    tomcat.enableNaming();
    return super.getTomcatWebServer(tomcat);
  }

  @Override
  protected void postProcessContext(Context context) {
    super.postProcessContext(context);
    try {
      URL resourceUrl = getClass().getResource("/META-INF/context.xml");
      if (resourceUrl != null) {
        Digester contextDigester = createContextDigester();
        contextDigester.getParser();

        contextDigester.setClassLoader(ContextConfig.class.getClassLoader());
        contextDigester.setUseContextClassLoader(false);
        contextDigester.push(context.getParent());
        contextDigester.push(context);

        try (InputStream resourceInputStream = resourceUrl.openStream()) {
          contextDigester.parse(resourceInputStream);
        }
      }
    } catch (IOException | SAXException e) {
      throw new IllegalStateException(e);
    }
  }

  protected Digester createContextDigester() {
    Digester digester = new Digester();
    digester.setValidating(false);
    digester.setRulesValidation(true);
    HashMap<Class<?>, List<String>> fakeAttributes = new HashMap<>();
    ArrayList<String> attrs = new ArrayList<>();
    attrs.add("className");
    fakeAttributes.put(Object.class, attrs);
    digester.setFakeAttributes(fakeAttributes);
    RuleSet contextRuleSet = new ContextRuleSet("", false);
    digester.addRuleSet(contextRuleSet);
    RuleSet namingRuleSet = new NamingRuleSet("Context/");
    digester.addRuleSet(namingRuleSet);
    return digester;
  }

  @Override
  protected void customizeConnector(Connector connector) {
    super.customizeConnector(connector);

    String port = System.getenv("PORT");
    if (port == null || port.isEmpty()) {
      port = "8000";
    }

    connector.setPort(Integer.parseInt(port));
  }
}
