package cronapp.framework.authentication.security;

import cronapp.framework.api.ApiManager;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

public class CronappAnonymousAuthenticationFilter extends AnonymousAuthenticationFilter {
  private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
  private String key;
  private Object principal;

  public CronappAnonymousAuthenticationFilter(String key, Object principal, List<GrantedAuthority> authorities) {
    super(key, principal, authorities);

    this.key = key;
    this.principal = principal;
  }

  @Override
  protected Authentication createAuthentication(HttpServletRequest request) {
    AnonymousAuthenticationToken auth = new AnonymousAuthenticationToken(key, principal, ApiManager.getPublicAuthorities());
    auth.setDetails(authenticationDetailsSource.buildDetails(request));

    return auth;
  }
}
