//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package cronapp.framework.authentication.saml;

import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.springframework.security.saml.context.SAMLContextProviderImpl;
import org.springframework.security.saml.context.SAMLMessageContext;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class SAMLContextProviderHeaders extends SAMLContextProviderImpl {

  public SAMLContextProviderHeaders() {
  }

  protected void populateGenericContext(HttpServletRequest request, HttpServletResponse response, SAMLMessageContext context) throws MetadataProviderException {
    super.populateGenericContext(new SAMLContextProviderHeaders.LPRequestWrapper(request), response, context);
  }

  private class LPRequestWrapper extends HttpServletRequestWrapper {
    private LPRequestWrapper(HttpServletRequest request) {
      super(request);
    }

    public String getContextPath() {
      return "";
    }

    public String getScheme() {
      return getHeader("X-Forwarded-Proto");
    }

    public String getServerName() {
      return getHeader("X-Forwarded-Host");
    }

    public int getServerPort() {
      return Integer.parseInt(getHeader("X-Forwarded-Port"));
    }

    public String getRequestURI() {
      StringBuilder sb = new StringBuilder(getContextPath());
      sb.append(this.getServletPath());
      return sb.toString();
    }

    public StringBuffer getRequestURL() {
      StringBuffer sb = new StringBuffer();
      sb.append(getScheme()).append("://").append(getServerName());
      sb.append(getContextPath());
      sb.append(this.getServletPath());
      if (this.getPathInfo() != null) {
        sb.append(this.getPathInfo());
      }

      return sb;
    }

    public boolean isSecure() {
      return "https".equalsIgnoreCase(getScheme());
    }
  }
}
