package cronapp.framework.authentication.nenhuma;

import cronapp.framework.api.ApiManager;
import cronapp.framework.authentication.security.CronappAnonymousAuthenticationFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.vote.UnanimousBased;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;

import cronapp.framework.authentication.security.Permission;

import java.util.List;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled = true)
public class AuthorizationConfigurer extends WebSecurityConfigurerAdapter {

  @Autowired(required = false)
  private Permission securityPermission;

  @Override
  protected void configure(HttpSecurity http) throws Exception {
    http.csrf().disable();

    if (securityPermission != null) {
      securityPermission.loadSecurityPermission(http);
    } else {
      http.authorizeRequests().anyRequest().permitAll();
    }
    http.headers().cacheControl().disable().frameOptions().disable().httpStrictTransportSecurity().disable();
  }


}
