package cronapp.framework.authentication.external;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicReference;

public class AcceptAllSSLSocketFactory extends SocketFactory {
  private static final Logger logger = LoggerFactory.getLogger(AcceptAllSSLSocketFactory.class);
  private static final AtomicReference<AcceptAllSSLSocketFactory> defaultFactory = new AtomicReference<>();

  private SSLSocketFactory sf;

  public AcceptAllSSLSocketFactory() {
    try {
      SSLContext ctx = SSLContext.getInstance("TLS");
      ctx.init(null, new TrustManager[]{new AcceptAllTrustmanager()}, new SecureRandom());
      sf = ctx.getSocketFactory();
    } catch (Exception ex) {
      logger.error(ex.getMessage(), ex);
      throw new RuntimeException(ex);
    }
  }

  public static synchronized SocketFactory getDefault() {
    final AcceptAllSSLSocketFactory value = defaultFactory.get();
    if (value == null) {
      defaultFactory.compareAndSet(null, new AcceptAllSSLSocketFactory());
      return defaultFactory.get();
    }
    return value;
  }

  @Override
  public Socket createSocket(final String s, final int i) throws IOException {
    return sf.createSocket(s, i);
  }

  @Override
  public Socket createSocket(final String s, final int i, final InetAddress inetAddress, final int i1) throws IOException {
    return sf.createSocket(s, i, inetAddress, i1);
  }

  @Override
  public Socket createSocket(final InetAddress inetAddress, final int i) throws IOException {
    return sf.createSocket(inetAddress, i);
  }

  @Override
  public Socket createSocket(final InetAddress inetAddress, final int i, final InetAddress inetAddress1, final int i1) throws IOException {
    return sf.createSocket(inetAddress, i, inetAddress1, i1);
  }
}
