package cronapp.framework.authentication.external;

import cronapi.AppConfig;
import cronapp.framework.i18n.Messages;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;

class LdapAuthenticator extends BasedInLdapAuthenticator {

  @Override
  public Authentication authenticate(Authentication authentication) throws AuthenticationException {
    Assert.isInstanceOf(UsernamePasswordAuthenticationToken.class, authentication, "Only UsernamePasswordAuthenticationToken is supported");

    final UsernamePasswordAuthenticationToken userToken = (UsernamePasswordAuthenticationToken) authentication;
    final String providerUrl = generateProviderUrl();
    final String credentials = userToken.getCredentials().toString();
    String principal = userToken.getPrincipal().toString() + '@' + AppConfig.defaultDomain();
    String alternativePrincipal = "uid=" + userToken.getPrincipal().toString() + ',' + AppConfig.defaultDomain();

    if (super.authenticate(providerUrl, principal, credentials) || super.authenticate(providerUrl, alternativePrincipal, credentials)) {
      return authentication;
    }

    throw new BadCredentialsException(Messages.getString("UserOrPassordInvalids"));
  }
}
