package cronapp.framework.authentication.sso;

import cronapp.framework.SessionListener;
import cronapp.framework.api.EventsManager;
import cronapp.framework.authentication.token.CorsFilter;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

import javax.servlet.http.HttpSessionListener;

@Configuration
public class BeanConfigurator {

  @Bean
  public FilterRegistrationBean configureFilters() {
    FilterRegistrationBean<CorsFilter> registrationBean = new FilterRegistrationBean<>();
    registrationBean.setFilter(new CorsFilter());
    registrationBean.setOrder(-1 * (Integer.MAX_VALUE - 1));
    return registrationBean;
  }
  
  @EventListener(ApplicationReadyEvent.class)
  public void doSomethingAfterStartup() {
    if (EventsManager.hasEvent("onSystemStarts")) {
      EventsManager.executeEventOnTransaction("onSystemStarts");
    }
  }

  @Bean
  public ServletListenerRegistrationBean<HttpSessionListener> sessionListener() {
    return new ServletListenerRegistrationBean<>(new SessionListener());
  }
}