package cronapp.framework.authentication.external;

import cronapi.AppConfig;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryLdapAuthenticationProvider;

class ActiveDirectoryAuthenticator extends BasedInLdapAuthenticator {

  @Override
  public Authentication authenticate(Authentication authentication) throws AuthenticationException {
    ActiveDirectoryLdapAuthenticationProvider provider = new ActiveDirectoryLdapAuthenticationProvider(AppConfig.defaultDomain(), generateProviderUrl());
    provider.setSearchFilter("(&(objectClass=user)(sAMAccountName={1}))");
    provider.setUserDetailsContextMapper(new ActiveDirectoryUserDetailsMapper(AppConfig.defaultDomain()));
    return provider.authenticate(authentication);
  }
}
