package cronapp.framework.authentication.token;

import cronapp.framework.i18n.Messages;
import org.springframework.web.cors.CorsUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Security;

public class CorsFilter implements Filter {

  static {
    Security.setProperty("keystore.type", "jks");
  }

  @Override
  public void init(FilterConfig filterConfig) {
  }

  @Override
  public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
    HttpServletResponse response = (HttpServletResponse)res;
    HttpServletRequest request = (HttpServletRequest)req;
    response.setHeader("Access-Control-Allow-Origin", "*");
    response.setHeader("Access-Control-Allow-Methods", "*");
    response.setHeader("Access-Control-Max-Age", "3600");
    response.setHeader("Access-Control-Allow-Headers", "origin-path, Origin, X-Requested-With, Content-Type, Accept, " + TokenUtils.AUTH_HEADER_NAME);
    try {
      Messages.set(req.getLocale());
      if (CorsUtils.isPreFlightRequest(request)) {
        response.setStatus(HttpServletResponse.SC_OK);
      } else {
        chain.doFilter(req, res);
      }
    } finally {
      Messages.remove();
    }
  }

  @Override
  public void destroy() {
  }
}