package cronapp.framework.authentication.external;

import cronapi.AppConfig;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class ExternalAuthenticationConfig {

  private static String type;

  private static final String INTERNAL = "internal";

  private static final String ACTIVE_DIRECTORY = "activeDirectory";

  private static final String LDAP = "ldap";

  static {
    type = AppConfig.type();
  }

  public static String getExternalAuthType() {
    return type;
  }

  public static boolean isExternalAuth() {
    return type != null && !INTERNAL.equals(type);
  }

  public static Authentication authenticateExternally(Authentication authentication) throws AuthenticationException {
    return authenticator(type).authenticate(authentication);
  }

  private static ExternalAuthenticator authenticator(String type) {
    if (ACTIVE_DIRECTORY.equals(type)) {
      return new ActiveDirectoryAuthenticator();
    } else if (LDAP.equals(type)) {
      return new LdapAuthenticator();
    }
    throw new ProviderNotFoundException(String.format("No AuthenticationProvider found for %s", type));
  }
}
