package cronapp.framework.authentication.security;

import cronapp.framework.api.ApiManager;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FilterInvocationVoter implements AccessDecisionVoter<FilterInvocation> {
  private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();

  @Override
  public boolean supports(ConfigAttribute attribute) {
    return true;
  }

  @Override
  public boolean supports(Class clazz) {
    return FilterInvocation.class.isAssignableFrom(clazz);
  }

  @Override
  public int vote(Authentication authentication, FilterInvocation filterInvocation, Collection collection) {

    List<RequestMatcher> matchers = authentication.getAuthorities().stream()
        .flatMap(authority -> ApiManager.getSecurableViews(authority.getAuthority()).stream())
        .map(securable -> securable.getStringField(ApiManager.SECURABLE_ATTRIBUTE_PATTERN))
        .flatMap(pattern -> Stream.of(pattern.split(",")))
        .distinct()
        .map(AntPathRequestMatcher::new)
        .collect(Collectors.toList());

    RequestMatcher matcher = new OrRequestMatcher(matchers);

    if (matcher.matches(filterInvocation.getRequest())) {
      return ACCESS_GRANTED;
    }

    return ACCESS_DENIED;
  }
}
