package cronapp.framework.authentication.token;

import java.io.IOException;
import java.util.Set;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

import cronapp.framework.api.ApiManager;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;

public class AuthenticationTokenFilter extends UsernamePasswordAuthenticationFilter {
  
  @Override
  public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
          throws IOException, ServletException {
    
    HttpServletRequest httpRequest = (HttpServletRequest)request;
    
    String authToken = httpRequest.getHeader(TokenUtils.AUTH_HEADER_NAME);
    String username = TokenUtils.getUsernameFromToken(authToken);
    
    if(username != null && SecurityContextHolder.getContext().getAuthentication() == null) {
      if(!TokenUtils.isTokenExpired(authToken)) {
        ApiManager apiManager = ApiManager.byUser(username);
        Set<GrantedAuthority> authorities = apiManager.getAuthorities();
        cronapp.framework.api.User user = new cronapp.framework.api.User(username);

        User userDetails = new User(user.getUsername(), user.getPassword(), false, false, false, false, authorities);
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(userDetails, null, authorities);
        authentication.setDetails(new WebAuthenticationDetailsSource().buildDetails(httpRequest));

        SecurityContextHolder.getContext().setAuthentication(authentication);
      }
    }
    
    chain.doFilter(httpRequest, response);
  }
  
}
