package cronapp.framework.authentication.external;

import cronapi.AppConfig;

public class ExternalAuthenticationConfig {

  private static String type;

  private static final String INTERNAL = "internal";

  private static final String ACTIVE_DIRECTORY = "activeDirectory";

  private static final String LDAP = "ldap";

  private static final String WSO2 = "wso2";

  static {
    type = AppConfig.type();
  }

  public static String getExternalAuthType() {
    return type;
  }

  public static boolean isExternalAuth() {
    return type != null && !INTERNAL.equals(type);
  }

  public static boolean authenticateExternally(String username, String password) {
    return authenticator(type).authenticate(username, password);
  }

  private static ExternalAuthenticator authenticator(String type) {
    if (ACTIVE_DIRECTORY.equals(type)) {
      return new ActiveDirectoryAuthenticator();
    } else if (LDAP.equals(type)) {
      return new LdapAuthenticator();
    } else if (WSO2.equals(type)) {
      return new WSO2Authenticator();
    }
    return new NoAuthenticator();
  }

  private static class NoAuthenticator implements ExternalAuthenticator {
    @Override
    public boolean authenticate(String username, String password) {
      return false;
    }
  }
}