package cronapp.framework.authentication.external;

import cronapi.AppConfig;
import org.apache.axis2.java.security.SSLProtocolSocketFactory;
import org.apache.axis2.java.security.TrustAllTrustManager;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.httpclient.protocol.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;

public class WSO2Authenticator implements ExternalAuthenticator {

  private static final Logger log = LoggerFactory.getLogger(WSO2Authenticator.class);

  private static final String SERVICE_NAME = "/services/AuthenticationAdmin";

  private static SSLContext SSL_CONTEXT;

  private AuthenticationAdminStub authenticationAdminStub;
  private String remoteAddress;

  static {
    initSSLContext();
  }

  @Override
  public boolean authenticate(String username, String password) {
    String endpoint = AppConfig.hostname() + SERVICE_NAME;
    boolean isAuthenticated = false;

    try {
      authenticationAdminStub = new AuthenticationAdminStub(endpoint);
      authenticationAdminStub._getServiceClient()
          .getOptions()
          .setProperty(HTTPConstants.CUSTOM_PROTOCOL_HANDLER,
              new Protocol("https", new SSLProtocolSocketFactory(SSL_CONTEXT), 443)
          );

      remoteAddress = new URL(endpoint).getHost();

      isAuthenticated = authenticationAdminStub.login(username, password, remoteAddress);
    } catch (MalformedURLException | RemoteException | LoginAuthenticationExceptionException e) {
      log.error(e.getMessage(), e);
    }

    return isAuthenticated;
  }

  private static void initSSLContext() {
    try {
      SSL_CONTEXT = SSLContext.getInstance("SSL");
      SSL_CONTEXT.init(null, new TrustManager[]{new TrustAllTrustManager()}, new java.security.SecureRandom());
    } catch (Exception e) {
      log.warn(e.getMessage(), e);
    }
  }
}