package cronapp.framework.authentication.token;

public class AuthenticationResponse {
  
  private Object user;
  
  private String token;
  
  private long expires;
  
  private String roles;
  
  private boolean root;
  
  public AuthenticationResponse() {
    super();
  }
  
  public AuthenticationResponse(Object user, String token, long expires, String roles, boolean root) {
    this.user = user;
    this.token = token;
    this.expires = expires;
    this.roles = roles;
    this.root = root;
  }
  
  public Object getUser() {
    return user;
  }
  
  public void setUser(Object user) {
    this.user = user;
  }
  
  public String getToken() {
    return token;
  }
  
  public void setToken(String token) {
    this.token = token;
  }
  
  public long getExpires() {
    return expires;
  }
  
  public void setExpires(long expires) {
    this.expires = expires;
  }
  
  public String getRoles() {
    return roles;
  }
  
  public void setRoles(String roles) {
    this.roles = roles;
  }
  
  public boolean isRoot() {
    return root;
  }
  
  public void setRoot(boolean root) {
    this.root = root;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    AuthenticationResponse that = (AuthenticationResponse)o;
    return user != null ? user.equals(that.user) : that.user == null;
  }
  
  @Override
  public int hashCode() {
    return user != null ? user.hashCode() : 0;
  }
  
  @Override
  public String toString() {
    return "AuthenticationResponse{" + "user=" + user + '}';
  }
}
