package cronapp.framework.authentication.social;

import cronapp.framework.authentication.normal.AuthenticationConfigurer;
import cronapp.framework.authentication.token.AuthenticationController;
import cronapp.framework.authentication.token.AuthenticationResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.mobile.device.Device;
import org.springframework.mobile.device.DeviceResolver;
import org.springframework.mobile.device.LiteDeviceResolver;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.web.SignInAdapter;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.NativeWebRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import com.google.gson.JsonObject;

@Service
public class SocialSignInAdapter implements SignInAdapter {

  @Autowired(required = false)
  private AuthenticationConfigurer authenticationConfigurer;

  @Autowired(required = false)
  private AuthenticationController authenticationController;

  @Autowired
  private HttpServletRequest servletRequest;

  @Override
  public String signIn(String localUserId, Connection<?> connection, NativeWebRequest request) {

    try {
      String email = connection.fetchUserProfile().getEmail();

      if (email == null) {
        email = connection.fetchUserProfile().getUsername();
      }
      
      JsonObject json = new JsonObject();
      json.addProperty("name", connection.getDisplayName());
      json.addProperty("image", connection.getImageUrl());

      String provider = connection.getKey().getProviderId();

      UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken(
          email, provider, Arrays.asList(new SimpleGrantedAuthority("#OAUTH#")));
      
      auth.setDetails(json);

      try {
        if (authenticationConfigurer != null) {
          authenticationConfigurer.authenticate(auth);

          SecurityContextHolder.getContext().setAuthentication(auth);

          servletRequest.getSession().setAttribute("#OAUTH#USER", email);
        } else {
          DeviceResolver deviceResolver = new LiteDeviceResolver();

          ResponseEntity<AuthenticationResponse> authenticationRequest = authenticationController.auth(email, provider, deviceResolver.resolveDevice(servletRequest), provider, null, json);

          return servletRequest.getContextPath() + "/#/connected?_ctk="+authenticationRequest.getBody().getToken();
        }
      } catch(Exception e) {
        return servletRequest.getContextPath() + "/#/notconnected";
      }
    } catch (Exception e) {
      return servletRequest.getContextPath() + "/#/error/403";
    }

    return servletRequest.getContextPath() + "/#/connected";

  }
}
