package cronapp.framework.authentication;

import cronapi.Var;
import cronapi.database.DatabaseQueryManager;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

/**
 * Controller responsável por gerir a troca de
 * senha do usuário através de serviço REST
 *
 * @author Techne
 */
@RestController
@RequestMapping(value = "/changePassword")
public class ChangePassword {

    private final PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();

    @SuppressWarnings("unchecked")
    @ResponseStatus(HttpStatus.OK)
    @RequestMapping(method = RequestMethod.POST)
    public void post(String oldPassword, String newPassword, String newPasswordConfirmation) throws Exception {
        if (!newPassword.equals(newPasswordConfirmation))
            throw new RuntimeException("Senha de confirmação diferente!");

        User userDetails = (User) SecurityContextHolder.getContext().getAuthentication().getPrincipal();

        DatabaseQueryManager getManager = new DatabaseQueryManager("auth");
        Var queryResult = getManager.get(userDetails.getUsername());
        if (queryResult.size() > 0) {
            Var userObject = queryResult.get(0);
            Var password = userObject.getField("password");
            String passwordString = password.getObjectAsString();
            if (passwordEncoder.matches(oldPassword, passwordString)) {
                String passwordEncoded = passwordEncoder.encode(newPassword);
                userObject.setField("password", passwordEncoded);
                DatabaseQueryManager putManager = new DatabaseQueryManager("updatePassword");
                putManager.update(userObject);
            } else {
                throw new BadCredentialsException("Usuário ou senha incorreta!");
            }
        } else {
            throw new UsernameNotFoundException("Usuário não encontrado!");
        }
    }
}
