package cronapp.framework.tenant;

import java.util.Set;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class MultitenantJpaTransactionManager extends JpaTransactionManager {
  
  private static final long serialVersionUID = 1L;
  
  private final TenantComponent tenantComponent;
  
  @Autowired
  public MultitenantJpaTransactionManager(TenantComponent tenantComponent) {
    this.tenantComponent = tenantComponent;
  }
  
  @Override
  protected void doBegin(Object transaction, TransactionDefinition definition) {
    super.doBegin(transaction, definition);
    EntityManagerFactory entityManagerFactory = getEntityManagerFactory();
    EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource(entityManagerFactory);
    EntityManager em = emHolder.getEntityManager();
    try {
      if(tenantComponent != null && tenantComponent.getContextIds() != null) {
        Set<String> keySet = tenantComponent.getContextIds().keySet();
        for(String key : keySet) {
          em.setProperty(key, tenantComponent.getId(key));
        }
      }
    }
    catch(Exception ignored) {
    }
  }
  
  @Override
  protected EntityManager createEntityManagerForTransaction() {
    return super.createEntityManagerForTransaction();
  }
}
