package cronapp.framework.authentication.social;

import cronapp.framework.authentication.normal.AuthenticationConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.web.SignInAdapter;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.NativeWebRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;

@Service
public class SocialSignInAdapter implements SignInAdapter {

  @Autowired
  private AuthenticationConfigurer authenticationConfigurer;

  @Autowired
  private HttpServletRequest servletRequest;

  @Override
  public String signIn(String localUserId, Connection<?> connection, NativeWebRequest request) {

    try {
      String email = connection.fetchUserProfile().getEmail();

      if (email == null) {
        email = connection.fetchUserProfile().getUsername();
      }

      UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken(
          email, "#OAUTH#", Arrays.asList(new SimpleGrantedAuthority("#OAUTH#")));

      try {
        authenticationConfigurer.authenticate(auth);

        SecurityContextHolder.getContext().setAuthentication(auth);

        servletRequest.getSession().setAttribute("#OAUTH#USER", email);
      } catch(Exception e) {
        return servletRequest.getContextPath() + "/#/notconnected";
      }
    } catch (Exception e) {
      return servletRequest.getContextPath() + "/#/error/403";
    }

    return servletRequest.getContextPath() + "/#/connected";

  }
}
