package cronapp.framework.authentication.social;

import cronapp.framework.authentication.normal.AuthenticationConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.web.SignInAdapter;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.NativeWebRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;

@Service
public class FacebookSignInAdapter implements SignInAdapter {

  @Autowired
  private AuthenticationConfigurer authenticationConfigurer;

  @Autowired
  private HttpServletRequest servletRequest;

  @Override
  public String signIn(String localUserId, Connection<?> connection, NativeWebRequest request) {

    String email = connection.fetchUserProfile().getEmail();

    UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken(
        email, "FACEBOOK", Arrays.asList(new SimpleGrantedAuthority("#OAUTH#")));

    authenticationConfigurer.authenticate(auth);

    SecurityContextHolder.getContext().setAuthentication(auth);

    try {
      servletRequest.getSession().setAttribute("#OAUTH#USER", email);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;

  }
}
