package cronapp.framework.api;

import cronapi.Var;

public final class User {

  private final String name;
  
  private final String username;
  
  private final String password;
  
  private final String theme;
  
  public User(String name, String username, String password, String theme) {
    this.username = username;
    this.password = password;
    this.theme = theme;
    this.name = name;
  }

  public User(String username) {
    this.name = username;
    this.username = username;
    this.password = "";
    this.theme = "";
  }
  
  public User(Var name, Var username, Var password, Var theme) {
    this.name = name.getObjectAsString();
    this.username = username.getObjectAsString();
    this.password = password.getObjectAsString();
    this.theme = theme.getObjectAsString();
  }
  
  public String getUsername() {
    return username;
  }
  
  public String getPassword() {
    return password;
  }
  
  public String getTheme() {
    return theme;
  }

  public String getName() {
    return name;
  }

  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    User user = (User)o;
    return username != null ? username.equals(user.username) : user.username == null;
  }
  
  @Override
  public int hashCode() {
    return username != null ? username.hashCode() : 0;
  }
  
  @Override
  public String toString() {
    return "User{" + "username='" + username + '\'' + '}';
  }
  
  public User resetPassword() {
    return new User(name, username, null, theme);
  }
  
}
