package cronapp.framework.rest;

import cronapi.Var;
import cronapp.framework.api.EventsManager;
import cronapp.framework.i18n.Messages;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import cronapp.framework.api.ApiManager;

/**
 * Controller responsável por gerir a troca de
 * senha do usuário através de serviço REST
 *
 * @author Techne
 */
@RestController
@RequestMapping(value = "/changeTheme")
public class ChangeTheme {
  
  @SuppressWarnings("unchecked")
  @ResponseStatus(HttpStatus.OK)
  @RequestMapping(method = RequestMethod.POST)
  public void post(String theme) throws Exception {
    User userDetails = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
    if (EventsManager.hasEvent("onChangeTheme")) {
      EventsManager.executeEventOnTransaction("onChangeTheme", Var.valueOf(userDetails.getUsername()), Var.valueOf(theme));
    } else {
      ApiManager apiManager = ApiManager.byUser(userDetails.getUsername());
      cronapp.framework.api.User user = apiManager.getUser();
      if (user == null) {
        throw new UsernameNotFoundException(Messages.getString("UserNotFound"));
      } else {
        apiManager.updateTheme(theme);
      }
    }
  }
}
