package cronapp.framework.authentication.social;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.connect.mem.InMemoryUsersConnectionRepository;
import org.springframework.social.connect.web.ProviderSignInController;

@Configuration
public class SocialConfigurer {

  @Autowired
  private ConnectionFactoryLocator connectionFactoryLocator;

  @Autowired
  private UsersConnectionRepository usersConnectionRepository;

  @Autowired
  private FacebookConnectionSignup facebookConnectionSignup;

  @Autowired
  private FacebookSignInAdapter facebookSignInAdapter;


  @Bean
  public ProviderSignInController providerSignInController() {
    ((InMemoryUsersConnectionRepository) usersConnectionRepository)
        .setConnectionSignUp(facebookConnectionSignup);

    return new ProviderSignInController(
        connectionFactoryLocator,
        usersConnectionRepository,
        facebookSignInAdapter);
  }
}
