package cronapp.framework.authentication.token;

public class AuthenticationRequest {
  
  private String username;
  
  private String password;
  
  public AuthenticationRequest() {
    super();
  }
  
  public AuthenticationRequest(String username, String password) {
    this.username = username;
    this.password = password;
  }
  
  public String getUsername() {
    return username;
  }
  
  public void setUsername(String username) {
    this.username = username;
  }
  
  public String getPassword() {
    return password;
  }
  
  public void setPassword(String password) {
    this.password = password;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    AuthenticationRequest that = (AuthenticationRequest)o;
    return username != null ? username.equals(that.username) : that.username == null;
  }
  
  @Override
  public int hashCode() {
    return username != null ? username.hashCode() : 0;
  }
  
  @Override
  public String toString() {
    return "AuthenticationRequest{" + "username='" + username + '\'' + '}';
  }
}
