package cronapp.framework;

import cronapp.framework.api.EventsManager;

import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionListener implements HttpSessionListener {
  
  public void sessionCreated(HttpSessionEvent event) {
    if(EventsManager.hasEvent("onSessionCreate")) {
      EventsManager.executeEventOnTransaction("onSessionCreate");
    }
  }
  
  public void sessionDestroyed(HttpSessionEvent event) {
    if(EventsManager.hasEvent("SessionDestroy")) {
      EventsManager.executeEventOnTransaction("SessionDestroy");
    }
  }
}
