package cronapp.framework.rest;

import cronapp.framework.i18n.Messages;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import cronapp.framework.api.ApiManager;

/**
 * Controller responsável por gerir a troca de
 * senha do usuário através de serviço REST
 *
 * @author Techne
 */
@RestController
@RequestMapping(value = "/changePassword")
public class ChangePassword {
  
  private final PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
  
  @SuppressWarnings("unchecked")
  @ResponseStatus(HttpStatus.OK)
  @RequestMapping(method = RequestMethod.POST)
  public void post(String oldPassword, String newPassword, String newPasswordConfirmation) throws Exception {
    if(!newPassword.equals(newPasswordConfirmation))
      throw new RuntimeException(Messages.getString("WrongConfirmationPassword"));
    
    User userDetails = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
    ApiManager apiManager = ApiManager.byUser(userDetails.getUsername());
    
    cronapp.framework.api.User user = apiManager.getUser();
    if(user == null) {
      throw new UsernameNotFoundException(Messages.getString("UserNotFound"));
    }
    else {
      String password = user.getPassword();
      if(apiManager.passwordMatches(oldPassword, password)) {
        String passwordEncoded = passwordEncoder.encode(newPassword);
        apiManager.updatePassword(passwordEncoded);
      }
      else {
        throw new BadCredentialsException(Messages.getString("UserOrPassordInvalids"));
      }
    }
  }
}
