package cronapp.framework.tenant;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cronapi.Var;
import cronapi.database.DatabaseQueryManager;

@Component
public class TenantComponentImpl implements TenantComponent {

	private static final Logger log = LoggerFactory.getLogger(TenantComponentImpl.class);

	private final TenantService tenantService;

	@Autowired
	public TenantComponentImpl(TenantService tenantService) {
		this.tenantService = tenantService;
	}

	@Override
	public void authenticationTenant(String username) {
		log.info("Tenant [User:Company:id] executed");
    DatabaseQueryManager query = new DatabaseQueryManager("tenant");
    try {
      Var value = query.get(username);
      if (value != null && value.getType() != Var.Type.NULL) {
        if (value.getType() == Var.Type.LIST && value.size() > 0) {
          this.tenantService.setId("tenant", value.get(0).getObject());
        } else {
          this.tenantService.setId("tenant", value.getObject());
        }
      }
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
	}

}
