/*
 * Decompiled with CFR 0.152.
 */
package io.cloudstate.javasupport.crdt;

import io.cloudstate.javasupport.crdt.Crdt;
import io.cloudstate.javasupport.crdt.ORMap;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

abstract class AbstractORMapWrapper<K, V, C extends Crdt>
extends AbstractMap<K, V>
implements Map<K, V> {
    final ORMap<K, C> ormap;

    AbstractORMapWrapper(ORMap<K, C> oRMap) {
        this.ormap = oRMap;
    }

    abstract V getCrdtValue(C var1);

    abstract void setCrdtValue(C var1, V var2);

    abstract C getOrUpdateCrdt(K var1, V var2);

    @Override
    public int size() {
        return this.ormap.size();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.ormap.containsKey(object);
    }

    @Override
    public V get(Object object) {
        Crdt crdt = (Crdt)this.ormap.get(object);
        if (crdt != null) {
            return this.getCrdtValue(crdt);
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        Crdt crdt = (Crdt)this.ormap.get(k);
        if (crdt != null) {
            V v2 = this.getCrdtValue(crdt);
            this.setCrdtValue(crdt, v);
            return v2;
        }
        this.getOrUpdateCrdt(k, v);
        return null;
    }

    @Override
    public V remove(Object object) {
        Crdt crdt = (Crdt)this.ormap.remove(object);
        if (crdt != null) {
            return this.getCrdtValue(crdt);
        }
        return null;
    }

    @Override
    public void clear() {
        this.ormap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.ormap.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return AbstractORMapWrapper.this.ormap.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<K, C>> iter;
                {
                    this.iter = AbstractORMapWrapper.this.ormap.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    return new MapEntry(this.iter.next());
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return !entry.getValue().equals(AbstractORMapWrapper.this.put(entry.getKey(), entry.getValue()));
        }

        @Override
        public void clear() {
            AbstractORMapWrapper.this.ormap.clear();
        }
    }

    private final class MapEntry
    implements Map.Entry<K, V> {
        private final Map.Entry<K, C> entry;

        MapEntry(Map.Entry<K, C> entry) {
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            return AbstractORMapWrapper.this.getCrdtValue((Crdt)this.entry.getValue());
        }

        @Override
        public V setValue(V v) {
            Object v2 = AbstractORMapWrapper.this.getCrdtValue((Crdt)this.entry.getValue());
            AbstractORMapWrapper.this.setCrdtValue((Crdt)this.entry.getValue(), v);
            return v2;
        }
    }
}

