/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import io.camunda.zeebe.client.api.response.Decision;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.Objects;

public final class DecisionImpl
implements Decision {
    private final String dmnDecisionId;
    private final String dmnDecisionName;
    private final int version;
    private final long decisionKey;
    private final String dmnDecisionRequirementsId;
    private final long decisionRequirementsKey;

    public DecisionImpl(GatewayOuterClass.DecisionMetadata metadata) {
        this(metadata.getDmnDecisionId(), metadata.getDmnDecisionName(), metadata.getVersion(), metadata.getDecisionKey(), metadata.getDmnDecisionRequirementsId(), metadata.getDecisionRequirementsKey());
    }

    public DecisionImpl(String dmnDecisionId, String dmnDecisionName, int version, long decisionKey, String dmnDecisionRequirementsId, long decisionRequirementsKey) {
        this.dmnDecisionId = dmnDecisionId;
        this.dmnDecisionName = dmnDecisionName;
        this.version = version;
        this.decisionKey = decisionKey;
        this.dmnDecisionRequirementsId = dmnDecisionRequirementsId;
        this.decisionRequirementsKey = decisionRequirementsKey;
    }

    @Override
    public String getDmnDecisionId() {
        return this.dmnDecisionId;
    }

    @Override
    public String getDmnDecisionName() {
        return this.dmnDecisionName;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getDecisionKey() {
        return this.decisionKey;
    }

    @Override
    public String getDmnDecisionRequirementsId() {
        return this.dmnDecisionRequirementsId;
    }

    @Override
    public long getDecisionRequirementsKey() {
        return this.decisionRequirementsKey;
    }

    public int hashCode() {
        return Objects.hash(this.dmnDecisionId, this.dmnDecisionName, this.version, this.decisionKey, this.dmnDecisionRequirementsId, this.decisionRequirementsKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionImpl decision = (DecisionImpl)o;
        return this.version == decision.version && this.decisionKey == decision.decisionKey && this.decisionRequirementsKey == decision.decisionRequirementsKey && Objects.equals(this.dmnDecisionId, decision.dmnDecisionId) && Objects.equals(this.dmnDecisionName, decision.dmnDecisionName) && Objects.equals(this.dmnDecisionRequirementsId, decision.dmnDecisionRequirementsId);
    }

    public String toString() {
        return "DecisionImpl{dmnDecisionId='" + this.dmnDecisionId + '\'' + ", dmnDecisionName='" + this.dmnDecisionName + '\'' + ", version=" + this.version + ", decisionKey=" + this.decisionKey + ", dmnDecisionRequirementsId='" + this.dmnDecisionRequirementsId + '\'' + ", decisionRequirementsKey=" + this.decisionRequirementsKey + '}';
    }
}

