/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist;

import com.apollographql.apollo3.ApolloCall;
import com.apollographql.apollo3.ApolloClient;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Mutation;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Optional;
import com.apollographql.apollo3.api.Query;
import com.apollographql.apollo3.exception.ApolloHttpException;
import com.apollographql.apollo3.rx3.Rx3Apollo;
import io.camunda.tasklist.auth.AuthInterface;
import io.camunda.tasklist.dto.Form;
import io.camunda.tasklist.dto.Task;
import io.camunda.tasklist.dto.TaskState;
import io.camunda.tasklist.exception.TaskListException;
import io.camunda.tasklist.util.ApolloUtils;
import io.generated.tasklist.client.ClaimTaskMutation;
import io.generated.tasklist.client.CompleteTaskMutation;
import io.generated.tasklist.client.GetFormQuery;
import io.generated.tasklist.client.GetTaskQuery;
import io.generated.tasklist.client.GetTasksQuery;
import io.generated.tasklist.client.GetTasksWithVariableQuery;
import io.generated.tasklist.client.UnclaimTaskMutation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CamundaTaskListClient {
    private AuthInterface authentication;
    private ApolloClient apolloClient;
    private String taskListUrl;
    private boolean defaultShouldReturnVariables;

    public Task unclaim(String taskId) throws TaskListException {
        ApolloCall unclaimCall = this.apolloClient.mutation((Mutation)new UnclaimTaskMutation(taskId));
        ApolloResponse response = this.execute(unclaimCall);
        return ApolloUtils.toTask(((UnclaimTaskMutation.Data)response.data).unclaimTask);
    }

    public Task claim(String taskId, String assignee) throws TaskListException {
        ApolloCall claimCall = this.apolloClient.mutation((Mutation)new ClaimTaskMutation(taskId, assignee));
        ApolloResponse response = this.execute(claimCall);
        return ApolloUtils.toTask(((ClaimTaskMutation.Data)response.data).claimTask);
    }

    public Task completeTask(String taskId, Map<String, Object> variablesMap) throws TaskListException {
        ApolloCall completeTaskCall = this.apolloClient.mutation((Mutation)new CompleteTaskMutation(taskId, ApolloUtils.toVariableInput(variablesMap)));
        ApolloResponse response = this.execute(completeTaskCall);
        return ApolloUtils.toTask(((CompleteTaskMutation.Data)response.data).completeTask);
    }

    public List<Task> getTasks(Boolean assigned, TaskState state, Integer pageSize) throws TaskListException {
        return this.getTasks(assigned, state, pageSize, this.defaultShouldReturnVariables);
    }

    public List<Task> getTasks(Boolean assigned, TaskState state, Integer pageSize, boolean getVariables) throws TaskListException {
        return this.getTasks(null, assigned, null, state, pageSize, getVariables);
    }

    public List<Task> getAssigneeTasks(String assigneeId, TaskState state, Integer pageSize) throws TaskListException {
        return this.getAssigneeTasks(assigneeId, state, pageSize, this.defaultShouldReturnVariables);
    }

    public List<Task> getAssigneeTasks(String assigneeId, TaskState state, Integer pageSize, boolean getVariables) throws TaskListException {
        return this.getTasks(null, true, assigneeId, state, pageSize, getVariables);
    }

    public List<Task> getGroupTasks(String group, TaskState state, Integer pageSize) throws TaskListException {
        return this.getGroupTasks(group, state, pageSize, this.defaultShouldReturnVariables);
    }

    public List<Task> getGroupTasks(String group, TaskState state, Integer pageSize, boolean getVariables) throws TaskListException {
        return this.getTasks(group, null, null, state, pageSize, getVariables);
    }

    public Task getTask(String taskId) throws TaskListException {
        ApolloCall queryCall = this.apolloClient.query((Query)new GetTaskQuery(taskId));
        ApolloResponse response = this.execute(queryCall);
        return ApolloUtils.toTask(((GetTaskQuery.Data)response.data).task);
    }

    public Form getForm(String formId, String processDefinitionId) throws TaskListException {
        ApolloCall queryCall = this.apolloClient.query((Query)new GetFormQuery(formId, processDefinitionId));
        ApolloResponse response = this.execute(queryCall);
        return ApolloUtils.toForm(((GetFormQuery.Data)response.data).form);
    }

    public List<Task> getTasks(String group, Boolean assigned, String assigneeId, TaskState state, Integer pageSize, boolean getVariables) throws TaskListException {
        Optional<String> optGroup = ApolloUtils.optional(group);
        Optional<String> optAssignee = ApolloUtils.optional(assigneeId);
        Optional<Boolean> optAssigned = ApolloUtils.optional(assigned);
        Optional<Integer> optPageSize = ApolloUtils.optional(pageSize);
        Optional<io.generated.tasklist.client.type.TaskState> optState = ApolloUtils.optional(state);
        if (!getVariables) {
            ApolloCall queryCall = this.apolloClient.query((Query)new GetTasksQuery(optGroup, optAssignee, optAssigned, optState, optPageSize, null, null, null));
            ApolloResponse response = this.execute(queryCall);
            return ApolloUtils.toTasks(((GetTasksQuery.Data)response.data).tasks);
        }
        ApolloCall queryCall = this.apolloClient.query((Query)new GetTasksWithVariableQuery(optGroup, optAssignee, optAssigned, optState, optPageSize, null, null, null));
        ApolloResponse response = this.execute(queryCall);
        return ApolloUtils.toTasks(((GetTasksWithVariableQuery.Data)response.data).tasks);
    }

    private <T extends Operation.Data> ApolloResponse<T> execute(ApolloCall<T> call) throws TaskListException {
        ApolloResponse result = null;
        try {
            result = (ApolloResponse)Rx3Apollo.single(call).blockingGet();
        }
        catch (ApolloHttpException e2) {
            if (e2.getStatusCode() == 401) {
                this.authentication.authenticate(this);
                try {
                    result = (ApolloResponse)Rx3Apollo.single(call).blockingGet();
                }
                catch (Exception e22) {
                    throw new TaskListException(e22);
                }
            }
            throw new TaskListException((Exception)((Object)e2));
        }
        if (result == null) {
            return null;
        }
        if (result.hasErrors()) {
            String errorString = result.errors.stream().map(e -> e.toString()).collect(Collectors.joining(","));
            throw new TaskListException(errorString);
        }
        return result;
    }

    public ApolloClient getApolloClient() {
        return this.apolloClient;
    }

    public String getTaskListUrl() {
        return this.taskListUrl;
    }

    public static class Builder {
        private AuthInterface authentication;
        private String taskListUrl;
        private boolean defaultShouldReturnVariables = false;

        public Builder authentication(AuthInterface authentication) {
            this.authentication = authentication;
            return this;
        }

        public Builder taskListUrl(String taskListUrl) {
            this.taskListUrl = taskListUrl;
            return this;
        }

        public Builder shouldReturnVariables() {
            this.defaultShouldReturnVariables = true;
            return this;
        }

        public CamundaTaskListClient build() throws TaskListException {
            CamundaTaskListClient client = new CamundaTaskListClient();
            client.authentication = this.authentication;
            client.taskListUrl = this.taskListUrl;
            client.defaultShouldReturnVariables = this.defaultShouldReturnVariables;
            client.apolloClient = new ApolloClient.Builder().httpServerUrl(this.formatUrl(this.taskListUrl)).addHttpHeader("", "").build();
            this.authentication.authenticate(client);
            return client;
        }

        private String formatUrl(String url) {
            if (url.endsWith("/graphql")) {
                return url;
            }
            if (url.endsWith("/")) {
                return url + "graphql";
            }
            return url + "/graphql";
        }
    }
}

