/*
 * Decompiled with CFR 0.152.
 */
package io.bretty.solver.normalization;

import io.bretty.solver.normalization.Attribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class FuncDep {
    protected final Set<Attribute> left;
    protected final Set<Attribute> right;

    public static Set<FuncDep> getSet(String exprs) {
        if (exprs.equals("")) {
            return new HashSet<FuncDep>();
        }
        exprs = exprs.replaceAll("\\s+", "");
        return FuncDep.getSet(exprs.split(";"));
    }

    public static Set<FuncDep> getSet(String[] exprs) {
        HashSet<FuncDep> fds = new HashSet<FuncDep>();
        for (String s : exprs) {
            fds.add(FuncDep.of(s));
        }
        return fds;
    }

    public static FuncDep of(String expr) {
        String[] halves = expr.split("-->");
        return FuncDep.of(halves[0], halves[1]);
    }

    public static FuncDep of(String left, String right) {
        left = left.replaceAll("\\s+", "");
        right = right.replaceAll("\\s+", "");
        String[] lefts = left.split(",");
        String[] rights = right.split(",");
        Builder bd = new Builder();
        for (String s : lefts) {
            bd.left(Attribute.of(s));
        }
        for (String s : rights) {
            bd.right(Attribute.of(s));
        }
        return bd.build();
    }

    public FuncDep(Set<Attribute> left, Set<Attribute> right) {
        this.left = new HashSet<Attribute>(left);
        this.right = new HashSet<Attribute>(right);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FuncDep)) {
            return false;
        }
        FuncDep fd = (FuncDep)o;
        return this.left.equals(fd.left) && this.right.equals(fd.right);
    }

    public Set<Attribute> getLeft() {
        return new HashSet<Attribute>(this.left);
    }

    public Set<Attribute> getRight() {
        return new HashSet<Attribute>(this.right);
    }

    public int hashCode() {
        int result = 17;
        for (Attribute at : this.left) {
            result = 31 * result + at.hashCode();
        }
        for (Attribute at : this.right) {
            result = 31 * result + at.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder((this.left.size() + this.right.size()) * 10);
        for (Attribute at : this.left) {
            sb.append(at.toString());
            sb.append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append(" --> ");
        for (Attribute at : this.right) {
            sb.append(at.toString());
            sb.append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }

    public static class Builder {
        private Set<Attribute> left = new HashSet<Attribute>();
        private Set<Attribute> right = new HashSet<Attribute>();

        public FuncDep build() {
            return new FuncDep(this.left, this.right);
        }

        public Builder left(Attribute ... as) {
            this.left.addAll(Arrays.asList(as));
            return this;
        }

        public Builder left(Set<Attribute> as) {
            this.left.addAll(as);
            return this;
        }

        public Builder right(Attribute ... as) {
            this.right.addAll(Arrays.asList(as));
            return this;
        }

        public Builder right(Set<Attribute> as) {
            this.right.addAll(as);
            return this;
        }
    }
}

