/*
 * Decompiled with CFR 0.152.
 */
package io.bretty.solver.normalization;

import io.bretty.solver.normalization.Attribute;
import io.bretty.solver.normalization.FuncDep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Algos {
    public static Set<FuncDep> check3NF(Set<Attribute> attrs, Set<FuncDep> fds) {
        Set<Set<Attribute>> keys = Algos.keys(attrs, fds);
        HashSet<Attribute> primes = new HashSet<Attribute>();
        for (Set<Attribute> k : keys) {
            primes.addAll(k);
        }
        HashSet<FuncDep> violating = new HashSet<FuncDep>();
        for (FuncDep fd : fds) {
            if (primes.containsAll(fd.getRight())) continue;
            boolean contains = false;
            for (Set<Attribute> k : keys) {
                if (!fd.getLeft().containsAll(k)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            violating.add(fd);
        }
        return violating;
    }

    public static Set<FuncDep> checkBCNF(Set<Attribute> attrs, Set<FuncDep> fds) {
        Set<Set<Attribute>> keys = Algos.keys(attrs, fds);
        HashSet<FuncDep> violating = new HashSet<FuncDep>();
        for (FuncDep fd : fds) {
            boolean contains = false;
            for (Set<Attribute> k : keys) {
                if (!fd.getLeft().containsAll(k)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            violating.add(fd);
        }
        return violating;
    }

    public static Set<FuncDep> checkLossyDecomposition(Set<Attribute> attrs, Set<FuncDep> fds, Set<Set<Attribute>> subattrs) {
        HashSet<FuncDep> lost = new HashSet<FuncDep>();
        HashSet<FuncDep> decomposed = new HashSet<FuncDep>();
        for (Set<Attribute> sa : subattrs) {
            decomposed.addAll(Algos.projection(sa, fds));
        }
        for (FuncDep fd : fds) {
            Set<Attribute> left = fd.getLeft();
            Set<Attribute> closure = Algos.closure(left, decomposed);
            if (closure.containsAll(fd.getRight())) continue;
            lost.add(fd);
        }
        return lost;
    }

    public static Set<Attribute> closure(Set<Attribute> attrs, Set<FuncDep> fds) {
        HashSet<Attribute> result = new HashSet<Attribute>(attrs);
        boolean found = true;
        while (found) {
            found = false;
            for (FuncDep fd : fds) {
                if (!result.containsAll(fd.left) || result.containsAll(fd.right)) continue;
                result.addAll(fd.right);
                found = true;
            }
        }
        return result;
    }

    public static void combineRight(Set<FuncDep> fds) {
        HashMap<Set<Attribute>, Set<Attribute>> map = new HashMap<Set<Attribute>, Set<Attribute>>();
        for (FuncDep fd : fds) {
            if (map.containsKey(fd.left)) {
                ((Set)map.get(fd.left)).addAll(fd.right);
                continue;
            }
            map.put(fd.left, fd.getRight());
        }
        fds.clear();
        for (Set left : map.keySet()) {
            fds.add(new FuncDep.Builder().left(left).right((Set)map.get(left)).build());
        }
    }

    public static boolean equivalent(Set<FuncDep> a, Set<FuncDep> b) {
        HashSet<Attribute> names = new HashSet<Attribute>();
        for (FuncDep fd : a) {
            names.addAll(fd.getLeft());
            names.addAll(fd.getRight());
        }
        for (FuncDep fd : b) {
            names.addAll(fd.getLeft());
            names.addAll(fd.getRight());
        }
        Set powerset = Algos.reducedPowerSet(names);
        for (Set<Attribute> set : powerset) {
            Set<Attribute> closureInB;
            Set<Attribute> closureInA = Algos.closure(set, a);
            if (closureInA.equals(closureInB = Algos.closure(set, b))) continue;
            return false;
        }
        return true;
    }

    public static Set<Set<Attribute>> keys(Set<Attribute> attrs, Set<FuncDep> fds) {
        Set<Set<Attribute>> superkeys = Algos.superKeys(attrs, fds);
        HashSet<Set<Attribute>> toRemove = new HashSet<Set<Attribute>>();
        block0: for (Set<Attribute> key : superkeys) {
            for (Attribute a : key) {
                HashSet<Attribute> remaining = new HashSet<Attribute>(key);
                remaining.remove(a);
                if (!superkeys.contains(remaining)) continue;
                toRemove.add(key);
                continue block0;
            }
        }
        superkeys.removeAll(toRemove);
        return superkeys;
    }

    public static Set<FuncDep> minimalBasis(Set<FuncDep> fds) {
        HashSet<FuncDep> result = new HashSet<FuncDep>(fds);
        Algos.splitRight(result);
        Algos.removeTrivial(result);
        int count = 1;
        while (count > 0) {
            count = Algos.removeUnnecessaryLeftSide(result) + Algos.removeUnnecessaryEntireFD(result);
        }
        return result;
    }

    public static <T> Set<Set<T>> powerSet(Set<T> originalSet) {
        HashSet<Set<T>> sets = new HashSet<Set<T>>();
        if (originalSet.isEmpty()) {
            sets.add(new HashSet());
            return sets;
        }
        ArrayList<T> list = new ArrayList<T>(originalSet);
        Object head = list.get(0);
        HashSet rest = new HashSet(list.subList(1, list.size()));
        for (Set set : Algos.powerSet(rest)) {
            HashSet newSet = new HashSet();
            newSet.add(head);
            newSet.addAll(set);
            sets.add(newSet);
            sets.add(set);
        }
        return sets;
    }

    public static Set<FuncDep> projection(Set<Attribute> attrs, Set<FuncDep> fds) {
        HashSet<Attribute> appeared = new HashSet<Attribute>();
        for (FuncDep fd : fds) {
            appeared.addAll(fd.getLeft());
            appeared.addAll(fd.getRight());
        }
        if (attrs.containsAll(appeared)) {
            return new HashSet<FuncDep>(fds);
        }
        HashSet notin = new HashSet(appeared);
        notin.removeAll(attrs);
        Set<Set<Attribute>> powerset = Algos.reducedPowerSet(attrs);
        HashSet<FuncDep> result = new HashSet<FuncDep>();
        for (Set<Attribute> sa : powerset) {
            Set<Attribute> closure = Algos.closure(sa, fds);
            closure.removeAll(notin);
            result.add(new FuncDep.Builder().left(sa).right(closure).build());
        }
        return Algos.minimalBasis(result);
    }

    public static <T> Set<Set<T>> reducedPowerSet(Set<T> originalSet) {
        Set<Set<T>> result = Algos.powerSet(originalSet);
        result.remove(new HashSet());
        return result;
    }

    public static void removeTrivial(Set<FuncDep> fds) {
        HashSet<FuncDep> toRemove = new HashSet<FuncDep>();
        HashSet<FuncDep> toAdd = new HashSet<FuncDep>();
        for (FuncDep fd : fds) {
            if (fd.left.containsAll(fd.right)) {
                toRemove.add(fd);
                continue;
            }
            HashSet<Attribute> toRemoveFromRight = new HashSet<Attribute>();
            for (Attribute a : fd.right) {
                if (!fd.left.contains(a)) continue;
                toRemoveFromRight.add(a);
            }
            if (toRemoveFromRight.isEmpty()) continue;
            Set<Attribute> right = fd.getRight();
            right.removeAll(toRemoveFromRight);
            toRemove.add(fd);
            toAdd.add(new FuncDep.Builder().left(fd.left).right(right).build());
        }
        fds.addAll(toAdd);
        fds.removeAll(toRemove);
    }

    public static int removeUnnecessaryEntireFD(Set<FuncDep> fds) {
        int count = 0;
        while (true) {
            FuncDep toRemove = null;
            boolean found = false;
            for (FuncDep fd : fds) {
                HashSet<FuncDep> remaining = new HashSet<FuncDep>(fds);
                remaining.remove(fd);
                if (!Algos.equivalent(remaining, fds)) continue;
                ++count;
                found = true;
                toRemove = fd;
                break;
            }
            if (!found) break;
            fds.remove(toRemove);
        }
        return count;
    }

    public static int removeUnnecessaryLeftSide(Set<FuncDep> fds) {
        int loop;
        int count = 0;
        do {
            boolean found = false;
            FuncDep toRemove = null;
            FuncDep toAdd = null;
            loop = 0;
            for (FuncDep fd : fds) {
                Set<Attribute> left = fd.getLeft();
                Set<Attribute> right = fd.getRight();
                if (left.size() > 1) {
                    for (Attribute a : left) {
                        HashSet<Attribute> remaining = new HashSet<Attribute>(left);
                        remaining.remove(a);
                        HashSet<FuncDep> alternative = new HashSet<FuncDep>(fds);
                        alternative.remove(fd);
                        toAdd = new FuncDep.Builder().left(remaining).right(right).build();
                        alternative.add(toAdd);
                        if (!Algos.equivalent(alternative, fds)) continue;
                        found = true;
                        toRemove = fd;
                        ++count;
                        break;
                    }
                }
                if (found) break;
                ++loop;
            }
            if (!found) continue;
            fds.remove(toRemove);
            fds.add(toAdd);
        } while (loop != fds.size());
        return count;
    }

    public static void splitRight(Set<FuncDep> fds) {
        HashSet<FuncDep> toRemove = new HashSet<FuncDep>();
        HashSet<FuncDep> toAdd = new HashSet<FuncDep>();
        for (FuncDep fd : fds) {
            if (fd.right.size() <= 1) continue;
            for (Attribute a : fd.right) {
                toAdd.add(new FuncDep.Builder().left(fd.left).right(a).build());
            }
            toRemove.add(fd);
        }
        fds.addAll(toAdd);
        fds.removeAll(toRemove);
    }

    public static Set<Set<Attribute>> superKeys(Set<Attribute> attrs, Set<FuncDep> fds) {
        HashSet<Set<Attribute>> keys = new HashSet<Set<Attribute>>();
        if (attrs.isEmpty()) {
            for (FuncDep fd : fds) {
                attrs.addAll(fd.left);
                attrs.addAll(fd.right);
            }
        }
        Set<Set<Attribute>> powerset = Algos.reducedPowerSet(attrs);
        for (Set<Attribute> sa : powerset) {
            if (!Algos.closure(sa, fds).equals(attrs)) continue;
            keys.add(sa);
        }
        return keys;
    }

    private Algos() {
    }
}

