/*
 * Decompiled with CFR 0.152.
 */
package io.atomicbits.scraml.jdsl;

import io.atomicbits.scraml.jdsl.BinaryData;
import io.atomicbits.scraml.jdsl.BinaryRequest;
import io.atomicbits.scraml.jdsl.BodyPart;
import io.atomicbits.scraml.jdsl.Client;
import io.atomicbits.scraml.jdsl.HeaderAdd;
import io.atomicbits.scraml.jdsl.HeaderMap;
import io.atomicbits.scraml.jdsl.HeaderOp;
import io.atomicbits.scraml.jdsl.HeaderSet;
import io.atomicbits.scraml.jdsl.HttpParam;
import io.atomicbits.scraml.jdsl.Method;
import io.atomicbits.scraml.jdsl.Response;
import io.atomicbits.scraml.jdsl.util.ListUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class RequestBuilder {
    private Client client;
    private List<String> path = new ArrayList<String>();
    private Method method = Method.GET;
    private Map<String, HttpParam> queryParameters = new HashMap<String, HttpParam>();
    private Map<String, HttpParam> formParameters = new HashMap<String, HttpParam>();
    private List<BodyPart> multipartParams = new ArrayList<BodyPart>(1);
    private BinaryRequest binaryRequest = null;
    private HeaderMap headerMap = new HeaderMap();
    private List<HeaderOp> headerOps = new ArrayList<HeaderOp>(1);
    RequestBuilder parentRequestBuilder;

    public RequestBuilder() {
    }

    public RequestBuilder(Client client) {
        this.client = client;
    }

    public RequestBuilder fold() {
        RequestBuilder requestBuilder = this.getParentRequestBuilder() != null ? this.getParentRequestBuilder().fold() : new RequestBuilder();
        if (this.getClient() != null) {
            requestBuilder.setClient(this.getClient());
        }
        this.path.forEach(requestBuilder::appendPathElement);
        if (this.method != null) {
            requestBuilder.setMethod(this.method);
        }
        this.queryParameters.forEach(requestBuilder::addQueryParameter);
        this.formParameters.forEach(requestBuilder::addFormParameter);
        this.multipartParams.forEach(requestBuilder::addMultipartParameter);
        if (this.binaryRequest != null) {
            requestBuilder.setBinaryRequest(this.binaryRequest);
        }
        for (HeaderOp headerOp : this.getHeaderOps()) {
            headerOp.process(requestBuilder.getHeaderMap());
        }
        return requestBuilder;
    }

    public Client getClient() {
        return this.client;
    }

    public Map<String, HttpParam> getFormParameters() {
        return this.formParameters;
    }

    public HeaderMap getHeaderMap() {
        return this.headerMap;
    }

    public List<HeaderOp> getHeaderOps() {
        return this.headerOps;
    }

    public void addHeader(String string, String string2) {
        HeaderAdd headerAdd = new HeaderAdd(string, string2);
        this.getHeaderOps().add(headerAdd);
    }

    public void setHeader(String string, String string2) {
        HeaderSet headerSet = new HeaderSet(string, string2);
        this.getHeaderOps().add(headerSet);
    }

    public Method getMethod() {
        return this.method;
    }

    public List<BodyPart> getMultipartParams() {
        return this.multipartParams;
    }

    public BinaryRequest getBinaryRequest() {
        return this.binaryRequest;
    }

    public void setBinaryRequest(BinaryRequest binaryRequest) {
        this.binaryRequest = binaryRequest;
    }

    public Map<String, HttpParam> getQueryParameters() {
        return this.queryParameters;
    }

    public List<String> getPath() {
        return this.path;
    }

    public RequestBuilder getParentRequestBuilder() {
        return this.parentRequestBuilder;
    }

    public void setParentRequestBuilder(RequestBuilder requestBuilder) {
        this.parentRequestBuilder = requestBuilder;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setFormParameters(Map<String, HttpParam> map) {
        this.formParameters = map == null ? new HashMap<String, HttpParam>() : map;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setMultipartParams(List<BodyPart> list) {
        this.multipartParams = list == null ? new ArrayList<BodyPart>() : list;
    }

    public void setPath(List<String> list) {
        this.path = list == null ? new ArrayList<String>() : list;
    }

    public void setQueryParameters(Map<String, HttpParam> map) {
        this.queryParameters = map == null ? new HashMap<String, HttpParam>() : map;
    }

    public void addQueryParameter(String string, HttpParam httpParam) {
        this.getQueryParameters().put(string, httpParam);
    }

    public void addFormParameter(String string, HttpParam httpParam) {
        this.getFormParameters().put(string, httpParam);
    }

    public void addMultipartParameter(BodyPart bodyPart) {
        this.getMultipartParams().add(bodyPart);
    }

    public String getRelativePath() {
        return ListUtils.mkString(this.path, "/");
    }

    public void appendPathElement(String string) {
        this.path.add(string);
    }

    public <B> CompletableFuture<Response<String>> callToStringResponse(B b, String string) {
        return this.client.callToStringResponse(this, b, string);
    }

    public <B> CompletableFuture<Response<BinaryData>> callToBinaryResponse(B b, String string) {
        return this.client.callToBinaryResponse(this, b, string);
    }

    public <B, R> CompletableFuture<Response<R>> callToTypeResponse(B b, String string, String string2) {
        return this.client.callToTypeResponse(this, b, string, string2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("client:\t\t" + this.client + "\n");
        stringBuilder.append("path:\t\t" + this.listToString(this.path) + "\n");
        stringBuilder.append("parent:\t\t" + this.parentRequestBuilder);
        return stringBuilder.toString();
    }

    private String listToString(List list) {
        String string = "";
        for (Object e : list) {
            string = string + e.toString() + ", ";
        }
        return string;
    }
}

