/*
 * Decompiled with CFR 0.152.
 */
package io.appium.mitmproxy;

import io.appium.mitmproxy.InterceptedMessage;
import io.appium.mitmproxy.MitmproxyServer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class MitmproxyJava {
    private static final Logger log = LoggerFactory.getLogger(MitmproxyJava.class);
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final int WEBSOCKET_PORT = 8765;
    private static final int TIMEOUT_FOR_SOCKET_CHECKING_MINS = 5;
    private final String mitmproxyPath;
    private final Function<InterceptedMessage, InterceptedMessage> messageInterceptor;
    private final int proxyPort;
    private MitmproxyServer server;
    private final List<String> extraMitmdumpParams;
    private Future<ProcessResult> mitmproxyProcess;

    public MitmproxyJava(String mitmproxyPath, Function<InterceptedMessage, InterceptedMessage> messageInterceptor, int proxyPort, List<String> extraMitmdumpParams) {
        this.mitmproxyPath = mitmproxyPath;
        this.messageInterceptor = messageInterceptor;
        this.proxyPort = proxyPort;
        this.extraMitmdumpParams = extraMitmdumpParams;
    }

    public MitmproxyJava(String mitmproxyPath, Function<InterceptedMessage, InterceptedMessage> messageInterceptor) {
        this(mitmproxyPath, messageInterceptor, 8080, null);
    }

    public MitmproxyJava start() throws IOException, TimeoutException {
        log.info("Starting mitmproxy on port {}", (Object)this.proxyPort);
        this.server = new MitmproxyServer(new InetSocketAddress(LOCALHOST_IP, 8765), this.messageInterceptor);
        this.server.start();
        String pythonScriptPath = this.extractPythonScriptToFile();
        ArrayList<String> mitmproxyStartParams = new ArrayList<String>();
        mitmproxyStartParams.add(this.mitmproxyPath);
        mitmproxyStartParams.add("--anticache");
        mitmproxyStartParams.add("-p");
        mitmproxyStartParams.add(String.valueOf(this.proxyPort));
        mitmproxyStartParams.add("-s");
        mitmproxyStartParams.add(pythonScriptPath);
        if (CollectionUtils.isNotEmpty(this.extraMitmdumpParams)) {
            mitmproxyStartParams.addAll(this.extraMitmdumpParams);
        }
        this.mitmproxyProcess = new ProcessExecutor().command(mitmproxyStartParams).redirectOutput((OutputStream)Slf4jStream.ofCaller().asInfo()).destroyOnExit().start().getFuture();
        this.waitForPortToBeInUse(this.proxyPort);
        log.info("Mitmproxy started on port {}", (Object)this.proxyPort);
        return this;
    }

    private String extractPythonScriptToFile() throws IOException {
        File outfile = File.createTempFile("mitmproxy-python-plugin", ".py");
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("scripts/proxy.py");
             FileOutputStream outputStream = new FileOutputStream(outfile);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        return outfile.getCanonicalPath();
    }

    public void stop() throws InterruptedException {
        if (this.mitmproxyProcess != null) {
            this.mitmproxyProcess.cancel(true);
        }
        this.server.stop(1000);
        this.waitForPortToBeFree(this.proxyPort);
    }

    private void waitForPortToBeFree(int port) {
        LocalDateTime timeoutTime = LocalDateTime.now().plusMinutes(5L);
        while (true) {
            if (timeoutTime.isBefore(LocalDateTime.now())) {
                throw new TimeoutException("Timed out waiting for mitmproxy to stop");
            }
            try {
                Socket s = new Socket(LOCALHOST_IP, port);
                Throwable throwable = null;
                if (s != null) {
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        s.close();
                    }
                }
            }
            catch (IOException ioe) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void waitForPortToBeInUse(int port) {
        LocalDateTime timeoutTime = LocalDateTime.now().plusMinutes(5L);
        while (true) {
            if (timeoutTime.isBefore(LocalDateTime.now())) {
                throw new TimeoutException("Timed out waiting for mitmproxy to start");
            }
            try {
                Socket s = new Socket(LOCALHOST_IP, port);
                Throwable throwable = null;
                if (s != null) {
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        s.close();
                    }
                }
                return;
            }
            catch (IOException ioe) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            break;
        }
    }
}

