/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.proxy;

import com.google.common.base.Preconditions;
import io.appium.java_client.proxy.Interceptor;
import io.appium.java_client.proxy.MethodCallListener;
import java.util.Collection;
import java.util.Collections;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Helpers {
    private Helpers() {
    }

    public static <T> T createProxy(Class<T> cls, Object[] constructorArgs, Class<?>[] constructorArgTypes, Collection<MethodCallListener> listeners) {
        Preconditions.checkArgument((constructorArgs.length == constructorArgTypes.length ? 1 : 0) != 0, (Object)String.format("Constructor arguments array length %d must be equal to the types array length %d", constructorArgs.length, constructorArgTypes.length));
        Preconditions.checkArgument((!listeners.isEmpty() ? 1 : 0) != 0, (Object)"The collection of listeners must not be empty");
        Preconditions.checkArgument((cls != null ? 1 : 0) != 0, (Object)"Class must not be null");
        Preconditions.checkArgument((!cls.isInterface() ? 1 : 0) != 0, (Object)"Class must not be an interface");
        Class<T> proxy = new ByteBuddy().subclass(cls).method((ElementMatcher)ElementMatchers.isPublic().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class).or((ElementMatcher)ElementMatchers.isOverriddenFrom(Object.class))))).intercept((Implementation)MethodDelegation.to(Interceptor.class)).make().load(cls.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded().asSubclass(cls);
        try {
            T instance = proxy.getConstructor(constructorArgTypes).newInstance(constructorArgs);
            Interceptor.LISTENERS.put(instance, listeners);
            return instance;
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new IllegalStateException(String.format("Unable to create a proxy of %s", cls.getName()), e);
        }
    }

    public static <T> T createProxy(Class<T> cls, Collection<MethodCallListener> listeners) {
        return Helpers.createProxy(cls, new Object[0], new Class[0], listeners);
    }

    public static <T> T createProxy(Class<T> cls, MethodCallListener listener) {
        return Helpers.createProxy(cls, new Object[0], new Class[0], Collections.singletonList(listener));
    }

    public static <T> T createProxy(Class<T> cls, Object[] constructorArgs, Class<?>[] constructorArgTypes, MethodCallListener listener) {
        return Helpers.createProxy(cls, constructorArgs, constructorArgTypes, Collections.singletonList(listener));
    }
}

