/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.imagecomparison.ComparisonMode;
import io.appium.java_client.imagecomparison.FeaturesMatchingOptions;
import io.appium.java_client.imagecomparison.FeaturesMatchingResult;
import io.appium.java_client.imagecomparison.OccurrenceMatchingOptions;
import io.appium.java_client.imagecomparison.OccurrenceMatchingResult;
import io.appium.java_client.imagecomparison.SimilarityMatchingOptions;
import io.appium.java_client.imagecomparison.SimilarityMatchingResult;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;

public interface ComparesImages
extends ExecutesMethod {
    default public FeaturesMatchingResult matchImagesFeatures(byte[] base64image1, byte[] base64Image2) {
        return this.matchImagesFeatures(base64image1, base64Image2, null);
    }

    default public FeaturesMatchingResult matchImagesFeatures(byte[] base64image1, byte[] base64Image2, @Nullable FeaturesMatchingOptions options) {
        Object response = CommandExecutionHelper.execute((ExecutesMethod)this, MobileCommand.compareImagesCommand(ComparisonMode.MATCH_FEATURES, base64image1, base64Image2, options));
        return new FeaturesMatchingResult((Map)response);
    }

    default public FeaturesMatchingResult matchImagesFeatures(File image1, File image2) throws IOException {
        return this.matchImagesFeatures(image1, image2, null);
    }

    default public FeaturesMatchingResult matchImagesFeatures(File image1, File image2, @Nullable FeaturesMatchingOptions options) throws IOException {
        return this.matchImagesFeatures(Base64.getEncoder().encode(FileUtils.readFileToByteArray((File)image1)), Base64.getEncoder().encode(FileUtils.readFileToByteArray((File)image2)), options);
    }

    default public OccurrenceMatchingResult findImageOccurrence(byte[] fullImage, byte[] partialImage) {
        return this.findImageOccurrence(fullImage, partialImage, null);
    }

    default public OccurrenceMatchingResult findImageOccurrence(byte[] fullImage, byte[] partialImage, @Nullable OccurrenceMatchingOptions options) {
        Object response = CommandExecutionHelper.execute((ExecutesMethod)this, MobileCommand.compareImagesCommand(ComparisonMode.MATCH_TEMPLATE, fullImage, partialImage, options));
        return new OccurrenceMatchingResult((Map)response);
    }

    default public OccurrenceMatchingResult findImageOccurrence(File fullImage, File partialImage) throws IOException {
        return this.findImageOccurrence(fullImage, partialImage, null);
    }

    default public OccurrenceMatchingResult findImageOccurrence(File fullImage, File partialImage, @Nullable OccurrenceMatchingOptions options) throws IOException {
        return this.findImageOccurrence(Base64.getEncoder().encode(FileUtils.readFileToByteArray((File)fullImage)), Base64.getEncoder().encode(FileUtils.readFileToByteArray((File)partialImage)), options);
    }

    default public SimilarityMatchingResult getImagesSimilarity(byte[] base64image1, byte[] base64Image2) {
        return this.getImagesSimilarity(base64image1, base64Image2, null);
    }

    default public SimilarityMatchingResult getImagesSimilarity(byte[] base64image1, byte[] base64Image2, @Nullable SimilarityMatchingOptions options) {
        Object response = CommandExecutionHelper.execute((ExecutesMethod)this, MobileCommand.compareImagesCommand(ComparisonMode.GET_SIMILARITY, base64image1, base64Image2, options));
        return new SimilarityMatchingResult((Map)response);
    }

    default public SimilarityMatchingResult getImagesSimilarity(File image1, File image2) throws IOException {
        return this.getImagesSimilarity(image1, image2, null);
    }

    default public SimilarityMatchingResult getImagesSimilarity(File image1, File image2, @Nullable SimilarityMatchingOptions options) throws IOException {
        return this.getImagesSimilarity(Base64.getEncoder().encode(FileUtils.readFileToByteArray((File)image1)), Base64.getEncoder().encode(FileUtils.readFileToByteArray((File)image2)), options);
    }
}

