/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.netty;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.function.Supplier;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.proxy.ProxyServer;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.remote.http.AddSeleniumUserAgent;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.netty.NettyClient;

class NettyMessages {
    private NettyMessages() {
    }

    protected static Request toNettyRequest(ClientConfig config, HttpRequest request) {
        URI baseUrl = config.baseUri();
        int timeout = NettyClient.toClampedInt(config.readTimeout().toMillis());
        Credentials credentials = config.credentials();
        String rawUrl = NettyMessages.getRawUrl(baseUrl, request.getUri());
        RequestBuilder builder = (RequestBuilder)((RequestBuilder)Dsl.request(request.getMethod().toString(), rawUrl).setReadTimeout(timeout)).setRequestTimeout(timeout);
        for (String name : request.getQueryParameterNames()) {
            for (String value : request.getQueryParameters(name)) {
                builder.addQueryParam(name, value);
            }
        }
        if (request.getMethod().equals((Object)HttpMethod.GET) && request.getHeader("Content-Length") != null) {
            request.removeHeader("Content-Length");
        }
        for (String name : request.getHeaderNames()) {
            for (String value : request.getHeaders(name)) {
                builder.addHeader((CharSequence)name, value);
            }
        }
        if (request.getHeader("User-Agent") == null) {
            builder.addHeader((CharSequence)"User-Agent", AddSeleniumUserAgent.USER_AGENT);
        }
        Realm.Builder realmBuilder = null;
        String info = baseUrl.getUserInfo();
        if (!Strings.isNullOrEmpty(info)) {
            String[] parts = info.split(":", 2);
            String user = parts[0];
            String pass = parts.length > 1 ? parts[1] : null;
            realmBuilder = Dsl.basicAuthRealm(user, pass).setUsePreemptiveAuth(true);
            builder.setRealm(realmBuilder);
        } else if (credentials != null) {
            if (!(credentials instanceof UsernameAndPassword)) {
                throw new IllegalArgumentException("Credentials must be a user name and password");
            }
            UsernameAndPassword uap = (UsernameAndPassword)credentials;
            realmBuilder = Dsl.basicAuthRealm(uap.username(), uap.password()).setUsePreemptiveAuth(true);
            builder.setRealm(realmBuilder);
        }
        if (config.proxy() != null) {
            InetSocketAddress address = (InetSocketAddress)config.proxy().address();
            ProxyServer.Builder proxyBuilder = new ProxyServer.Builder(address.getHostName(), address.getPort());
            if (realmBuilder != null) {
                proxyBuilder.setRealm(realmBuilder);
            }
            builder.setProxyServer(proxyBuilder);
        }
        if (request.getMethod().equals((Object)HttpMethod.POST)) {
            builder.setBody((InputStream)request.getContent().get());
        }
        return builder.build();
    }

    public static HttpResponse toSeleniumResponse(Response response) {
        HttpResponse toReturn = new HttpResponse();
        toReturn.setStatus(response.getStatusCode());
        toReturn.setContent((Supplier)(!response.hasResponseBody() ? Contents.empty() : Contents.memoize(response::getResponseBodyAsStream)));
        response.getHeaders().names().forEach(name -> response.getHeaders((CharSequence)name).forEach(value -> toReturn.addHeader((String)name, (String)value)));
        return toReturn;
    }

    private static String getRawUrl(URI baseUrl, String uri) {
        String rawUrl = uri.startsWith("ws://") ? "http://" + uri.substring("ws://".length()) : (uri.startsWith("wss://") ? "https://" + uri.substring("wss://".length()) : (uri.startsWith("http://") || uri.startsWith("https://") ? uri : baseUrl.toString().replaceAll("/$", "") + uri));
        return rawUrl;
    }
}

