/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.AcceptedW3CCapabilityKeys;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.session.CapabilitiesFilter;
import org.openqa.selenium.remote.session.CapabilityTransform;
import org.openqa.selenium.remote.session.ChromeFilter;
import org.openqa.selenium.remote.session.EdgeFilter;
import org.openqa.selenium.remote.session.FirefoxFilter;
import org.openqa.selenium.remote.session.InternetExplorerFilter;
import org.openqa.selenium.remote.session.OperaFilter;
import org.openqa.selenium.remote.session.ProxyTransform;
import org.openqa.selenium.remote.session.SafariFilter;
import org.openqa.selenium.remote.session.StripAnyPlatform;
import org.openqa.selenium.remote.session.W3CPlatformNameNormaliser;

public class CapabilitiesUtils {
    private static final Predicate<String> ACCEPTED_W3C_PATTERNS = new AcceptedW3CCapabilityKeys();

    private CapabilitiesUtils() {
    }

    public static Stream<Capabilities> makeW3CSafe(Capabilities possiblyInvalidCapabilities) {
        Require.nonNull("Capabilities", possiblyInvalidCapabilities);
        return CapabilitiesUtils.makeW3CSafe(possiblyInvalidCapabilities.asMap()).map(ImmutableCapabilities::new);
    }

    public static Stream<Map<String, Object>> makeW3CSafe(Map<String, Object> possiblyInvalidCapabilities) {
        Require.nonNull("Capabilities", possiblyInvalidCapabilities);
        Set<CapabilitiesFilter> adapters = CapabilitiesUtils.getCapabilityFilters();
        Map<String, Object> oss = CapabilitiesUtils.convertOssToW3C(possiblyInvalidCapabilities);
        HashSet usedKeys = new HashSet();
        ImmutableList firsts = adapters.stream().map(adapter -> adapter.apply(oss)).filter(Objects::nonNull).filter(map -> !map.isEmpty()).map(map -> map.entrySet().stream().filter(entry -> entry.getKey() != null).filter(entry -> ACCEPTED_W3C_PATTERNS.test((String)entry.getKey())).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).peek(map -> usedKeys.addAll(map.keySet())).collect(ImmutableList.toImmutableList());
        if (firsts.isEmpty()) {
            firsts = ImmutableList.of(ImmutableMap.of());
        }
        Map always = oss.entrySet().stream().filter(entry -> !usedKeys.contains(entry.getKey())).filter(entry -> entry.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        Stream<Map<String, Object>> fromOss = firsts.stream().map(first -> ImmutableMap.builder().putAll(always).putAll(first).build()).map(CapabilitiesUtils::applyTransforms).map(map -> map.entrySet().stream().filter(entry -> ACCEPTED_W3C_PATTERNS.test((String)entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        return fromOss;
    }

    private static Map<String, Object> convertOssToW3C(Map<String, Object> capabilities) {
        Map<String, Object> proxyMap;
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>(capabilities);
        if (capabilities.containsKey("platform") && !capabilities.containsKey("platformName")) {
            toReturn.put("platformName", String.valueOf(capabilities.get("platform")));
        }
        if (capabilities.containsKey("proxy") && (proxyMap = CapabilitiesUtils.getProxyFromCapabilities(capabilities)).containsKey("noProxy")) {
            HashMap<String, Object> w3cProxyMap = new HashMap<String, Object>(proxyMap);
            Object rawData = proxyMap.get("noProxy");
            if (rawData instanceof String) {
                w3cProxyMap.put("noProxy", Arrays.asList(((String)rawData).split(",\\s*")));
            }
            toReturn.put("proxy", w3cProxyMap);
        }
        return toReturn;
    }

    private static Map<String, Object> getProxyFromCapabilities(Map<String, Object> capabilities) {
        Object rawProxy = capabilities.get("proxy");
        if (rawProxy instanceof Proxy) {
            return ((Proxy)rawProxy).toJson();
        }
        if (rawProxy instanceof Map) {
            return (Map)rawProxy;
        }
        return new HashMap<String, Object>();
    }

    private static Map<String, Object> applyTransforms(Map<String, Object> caps) {
        LinkedList<Map.Entry<String, Object>> toExamine = new LinkedList<Map.Entry<String, Object>>(caps.entrySet());
        HashSet<String> seenKeys = new HashSet<String>();
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        Set<CapabilityTransform> transforms = CapabilitiesUtils.getCapabilityTransforms();
        block0: while (!toExamine.isEmpty()) {
            Map.Entry<String, Object> entry = (Map.Entry<String, Object>)toExamine.remove();
            seenKeys.add((String)entry.getKey());
            if (entry.getValue() == null) continue;
            for (CapabilityTransform transform : transforms) {
                Collection<Map.Entry<String, Object>> result = transform.apply(entry);
                if (result == null) {
                    toReturn.remove(entry.getKey());
                    continue block0;
                }
                for (Map.Entry<String, Object> newEntry : result) {
                    if (!seenKeys.contains(newEntry.getKey())) {
                        toExamine.add(newEntry);
                        continue;
                    }
                    if (newEntry.getKey().equals(entry.getKey())) {
                        entry = newEntry;
                    }
                    toReturn.put(newEntry.getKey(), newEntry.getValue());
                }
            }
        }
        return toReturn;
    }

    private static Set<CapabilitiesFilter> getCapabilityFilters() {
        ImmutableSet.Builder adapters = ImmutableSet.builder();
        ServiceLoader.load(CapabilitiesFilter.class).forEach(adapters::add);
        ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)adapters.add(new ChromeFilter())).add(new EdgeFilter())).add(new FirefoxFilter())).add(new InternetExplorerFilter())).add(new OperaFilter())).add(new SafariFilter());
        return adapters.build();
    }

    private static Set<CapabilityTransform> getCapabilityTransforms() {
        ImmutableSet.Builder transforms = ImmutableSet.builder();
        ServiceLoader.load(CapabilityTransform.class).forEach(transforms::add);
        ((ImmutableSet.Builder)((ImmutableSet.Builder)transforms.add(new ProxyTransform())).add(new StripAnyPlatform())).add(new W3CPlatformNameNormaliser());
        return transforms.build();
    }
}

