/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.WebDriverException;

public enum Platform {
    WINDOWS(new String[]{""}){

        @Override
        public Platform family() {
            return null;
        }
    }
    ,
    XP(new String[]{"Windows Server 2003", "xp", "windows", "winnt", "windows_nt", "windows nt"}){

        @Override
        public Platform family() {
            return WINDOWS;
        }

        public String toString() {
            return "Windows XP";
        }
    }
    ,
    VISTA(new String[]{"windows vista", "Windows Server 2008", "windows 7", "win7"}){

        @Override
        public Platform family() {
            return WINDOWS;
        }

        public String toString() {
            return "Windows Vista";
        }
    }
    ,
    WIN8(new String[]{"Windows Server 2012", "windows 8", "win8"}){

        @Override
        public Platform family() {
            return WINDOWS;
        }

        public String toString() {
            return "Windows 8";
        }
    }
    ,
    WIN8_1(new String[]{"windows 8.1", "win8.1"}){

        @Override
        public Platform family() {
            return WINDOWS;
        }

        public String toString() {
            return "Windows 8.1";
        }
    }
    ,
    WIN10(new String[]{"windows 10", "win10"}){

        @Override
        public Platform family() {
            return WINDOWS;
        }

        public String toString() {
            return "Windows 10";
        }
    }
    ,
    WIN11(new String[]{"windows 11", "win11"}){

        @Override
        public Platform family() {
            return WINDOWS;
        }

        public String toString() {
            return "Windows 11";
        }
    }
    ,
    MAC(new String[]{"mac", "darwin", "macOS", "mac os x", "os x"}){

        @Override
        public Platform family() {
            return null;
        }
    }
    ,
    SNOW_LEOPARD(new String[]{"snow leopard", "os x 10.6", "macos 10.6"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "OS X 10.6";
        }
    }
    ,
    MOUNTAIN_LION(new String[]{"mountain lion", "os x 10.8", "macos 10.8"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "OS X 10.8";
        }
    }
    ,
    MAVERICKS(new String[]{"mavericks", "os x 10.9", "macos 10.9"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "OS X 10.9";
        }
    }
    ,
    YOSEMITE(new String[]{"yosemite", "os x 10.10", "macos 10.10"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "OS X 10.10";
        }
    }
    ,
    EL_CAPITAN(new String[]{"el capitan", "os x 10.11", "macos 10.11"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "OS X 10.11";
        }
    }
    ,
    SIERRA(new String[]{"sierra", "os x 10.12", "macos 10.12"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "macOS 10.12";
        }
    }
    ,
    HIGH_SIERRA(new String[]{"high sierra", "os x 10.13", "macos 10.13"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "macOS 10.13";
        }
    }
    ,
    MOJAVE(new String[]{"mojave", "os x 10.14", "macos 10.14"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "macOS 10.14";
        }
    }
    ,
    CATALINA(new String[]{"catalina", "os x 10.15", "macos 10.15"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "macOS 10.15";
        }
    }
    ,
    BIG_SUR(new String[]{"big sur", "os x 11.0", "macos 11.0"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "macOS 11.0";
        }
    }
    ,
    MONTEREY(new String[]{"monterey", "os x 12.0", "macos 12.0"}){

        @Override
        public Platform family() {
            return MAC;
        }

        public String toString() {
            return "macOS 12.0";
        }
    }
    ,
    UNIX(new String[]{"solaris", "bsd"}){

        @Override
        public Platform family() {
            return null;
        }
    }
    ,
    LINUX(new String[]{"linux"}){

        @Override
        public Platform family() {
            return UNIX;
        }
    }
    ,
    ANDROID(new String[]{"android", "dalvik"}){

        @Override
        public Platform family() {
            return null;
        }
    }
    ,
    IOS(new String[]{"iOS"}){

        @Override
        public Platform family() {
            return null;
        }
    }
    ,
    ANY(new String[]{""}){

        @Override
        public Platform family() {
            return ANY;
        }

        @Override
        public boolean is(Platform compareWith) {
            return this == compareWith;
        }
    };

    private static Platform current;
    private final String[] partOfOsName;
    private int minorVersion = 0;
    private int majorVersion = 0;

    private Platform(String ... partOfOsName) {
        this.partOfOsName = partOfOsName;
    }

    public static Platform getCurrent() {
        if (current == null) {
            current = Platform.extractFromSysProperty(System.getProperty("os.name"));
            String version = System.getProperty("os.version", "0.0.0");
            int major = 0;
            int min2 = 0;
            Pattern pattern = Pattern.compile("^(\\d+)\\.(\\d+).*");
            Matcher matcher = pattern.matcher(version);
            if (matcher.matches()) {
                try {
                    major = Integer.parseInt(matcher.group(1));
                    min2 = Integer.parseInt(matcher.group(2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Platform.current.majorVersion = major;
            Platform.current.minorVersion = min2;
        }
        return current;
    }

    public static Platform extractFromSysProperty(String osName) {
        return Platform.extractFromSysProperty(osName, System.getProperty("os.version"));
    }

    public static Platform extractFromSysProperty(String osName, String osVersion) {
        osName = osName.toLowerCase();
        if ("dalvik".equalsIgnoreCase(System.getProperty("java.vm.name"))) {
            return ANDROID;
        }
        if (osVersion.equals("6.2") && osName.startsWith("windows nt")) {
            return WIN8;
        }
        if (osVersion.equals("6.3") && osName.startsWith("windows nt")) {
            return WIN8_1;
        }
        Platform mostLikely = UNIX;
        String previousMatch = null;
        for (Platform os : Platform.values()) {
            for (String matcher : os.partOfOsName) {
                if ("".equals(matcher)) continue;
                if (os.isExactMatch(osName, matcher = matcher.toLowerCase())) {
                    return os;
                }
                if (!os.isCurrentPlatform(osName, matcher) || !Platform.isBetterMatch(previousMatch, matcher)) continue;
                previousMatch = matcher;
                mostLikely = os;
            }
        }
        return mostLikely;
    }

    public static Platform fromString(String name) {
        for (Platform platform : Platform.values()) {
            if (!platform.toString().equalsIgnoreCase(name)) continue;
            return platform;
        }
        for (Platform os : Platform.values()) {
            for (String matcher : os.partOfOsName) {
                if (!name.equalsIgnoreCase(matcher)) continue;
                return os;
            }
        }
        throw new WebDriverException("Unrecognized platform: " + name);
    }

    private static boolean isBetterMatch(String previous, String matcher) {
        return previous == null || matcher.length() >= previous.length();
    }

    public String[] getPartOfOsName() {
        return Arrays.copyOf(this.partOfOsName, this.partOfOsName.length);
    }

    public boolean is(Platform compareWith) {
        return this == compareWith || compareWith == ANY || this.family() != null && this.family().is(compareWith);
    }

    public abstract Platform family();

    private boolean isCurrentPlatform(String osName, String matchAgainst) {
        return osName.contains(matchAgainst);
    }

    private boolean isExactMatch(String osName, String matchAgainst) {
        return matchAgainst.equals(osName);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }
}

