/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.EmptyMetricData;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.CollectionHandle;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorageUtils;
import io.opentelemetry.sdk.resources.Resource;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class TemporalMetricStorage<T, U extends ExemplarData> {
    private final Aggregator<T, U> aggregator;
    private final boolean isSynchronous;
    private final Map<CollectionHandle, LastReportedAccumulation<T>> reportHistory = new HashMap<CollectionHandle, LastReportedAccumulation<T>>();

    TemporalMetricStorage(Aggregator<T, U> aggregator, boolean isSynchronous) {
        this.aggregator = aggregator;
        this.isSynchronous = isSynchronous;
    }

    synchronized MetricData buildMetricFor(CollectionHandle collector, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, AggregationTemporality temporality, Map<Attributes, T> currentAccumulation, long startEpochNanos, long epochNanos) {
        long lastCollectionEpoch = startEpochNanos;
        Map<Attributes, T> result = currentAccumulation;
        if (this.reportHistory.containsKey(collector)) {
            LastReportedAccumulation<T> last = this.reportHistory.get(collector);
            lastCollectionEpoch = last.getEpochNanos();
            if (temporality == AggregationTemporality.DELTA && !this.isSynchronous) {
                MetricStorageUtils.diffInPlace(last.getAccumulation(), currentAccumulation, this.aggregator);
                result = last.getAccumulation();
            } else if (temporality == AggregationTemporality.CUMULATIVE && this.isSynchronous) {
                MetricStorageUtils.mergeAndPreserveInPlace(last.getAccumulation(), currentAccumulation, this.aggregator);
                if (last.getAccumulation().size() > 2000) {
                    MetricStorageUtils.removeUnseen(last.getAccumulation(), currentAccumulation);
                }
                result = last.getAccumulation();
            }
        }
        if (this.isSynchronous) {
            this.reportHistory.put(collector, new LastReportedAccumulation<T>(result, epochNanos));
        } else {
            this.reportHistory.put(collector, new LastReportedAccumulation<T>(currentAccumulation, epochNanos));
        }
        if (result.isEmpty()) {
            return EmptyMetricData.getInstance();
        }
        return this.aggregator.toMetricData(resource, instrumentationScopeInfo, descriptor, result, temporality, startEpochNanos, lastCollectionEpoch, epochNanos);
    }

    private static class LastReportedAccumulation<T> {
        private final Map<Attributes, T> accumulation;
        private final long epochNanos;

        LastReportedAccumulation(Map<Attributes, T> accumulation, long epochNanos) {
            this.accumulation = accumulation;
            this.epochNanos = epochNanos;
        }

        long getEpochNanos() {
            return this.epochNanos;
        }

        Map<Attributes, T> getAccumulation() {
            return this.accumulation;
        }
    }
}

