/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.autoconfigure.LogExporterConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.logs.LogProcessor;
import io.opentelemetry.sdk.logs.SdkLogEmitterProviderBuilder;
import io.opentelemetry.sdk.logs.export.BatchLogProcessor;
import io.opentelemetry.sdk.logs.export.LogExporter;
import io.opentelemetry.sdk.logs.export.SimpleLogProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

final class LogEmitterProviderConfiguration {
    static void configureLogEmitterProvider(SdkLogEmitterProviderBuilder logEmitterProviderBuilder, ConfigProperties config, MeterProvider meterProvider, BiFunction<? super LogExporter, ConfigProperties, ? extends LogExporter> logExporterCustomizer) {
        Map<String, LogExporter> exportersByName = LogExporterConfiguration.configureLogExporters(config, meterProvider, logExporterCustomizer);
        LogEmitterProviderConfiguration.configureLogProcessors(exportersByName, meterProvider).forEach(logEmitterProviderBuilder::addLogProcessor);
    }

    static List<LogProcessor> configureLogProcessors(Map<String, LogExporter> exportersByName, MeterProvider meterProvider) {
        HashMap<String, LogExporter> exportersByNameCopy = new HashMap<String, LogExporter>(exportersByName);
        ArrayList<LogProcessor> logProcessors = new ArrayList<LogProcessor>();
        LogExporter exporter = (LogExporter)exportersByNameCopy.remove("logging");
        if (exporter != null) {
            logProcessors.add(SimpleLogProcessor.create(exporter));
        }
        if (!exportersByNameCopy.isEmpty()) {
            LogExporter compositeLogExporter = LogExporter.composite(exportersByNameCopy.values());
            logProcessors.add(BatchLogProcessor.builder(compositeLogExporter).setMeterProvider(meterProvider).build());
        }
        return logProcessors;
    }

    private LogEmitterProviderConfiguration() {
    }
}

